/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.radius.common.tls.recordlayer;

import com.tplink.cdd.radius.common.tls.enums.RecordLayerType;
import com.tplink.cdd.radius.common.tls.enums.TlsVersion;
import com.tplink.cdd.radius.common.tls.recordlayer.RecordLayer;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;

public class ChangeCipherSpec
extends RecordLayer {
    private final byte changeCipherSpecMessage;

    protected ChangeCipherSpec(ByteBuf byteBuf) {
        super(RecordLayerType.CHANGE_CIPHER_SPEC, byteBuf);
        this.changeCipherSpecMessage = byteBuf.readByte();
    }

    public ChangeCipherSpec(TlsVersion tlsVersion) {
        this.changeCipherSpecMessage = 1;
        this.init(RecordLayerType.CHANGE_CIPHER_SPEC, tlsVersion);
    }

    @Override
    protected ByteBuf getOtherData() {
        return Unpooled.buffer().writeByte((int)this.changeCipherSpecMessage);
    }

    public byte getChangeCipherSpecMessage() {
        return this.changeCipherSpecMessage;
    }
}

