/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.radius.common.tls.recordlayer;

import com.tplink.cdd.radius.common.tls.CipherSuite.TlsCipher;
import com.tplink.cdd.radius.common.tls.enums.RecordLayerType;
import com.tplink.cdd.radius.common.tls.recordlayer.RecordLayer;
import com.tplink.cdd.radius.common.utils.TlsUtil;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;

public class ApplicationData
extends RecordLayer {
    private byte[] plainText;
    private byte[] cipherText;

    protected ApplicationData(ByteBuf byteBuf, TlsCipher tlsCipher) {
        super(RecordLayerType.APPLICATION_DATA, byteBuf);
        ByteBuf cipherText = byteBuf.readBytes((int)this.getLength());
        this.plainText = TlsUtil.decryptTlsText(tlsCipher, RecordLayerType.APPLICATION_DATA, ByteBufUtil.getBytes((ByteBuf)cipherText));
    }

    public ApplicationData(byte[] plainText, TlsCipher tlsCipher) {
        this.cipherText = TlsUtil.encryptTlsText(tlsCipher, RecordLayerType.APPLICATION_DATA, plainText);
        this.init(RecordLayerType.APPLICATION_DATA, tlsCipher.getTlsVersion());
    }

    @Override
    protected ByteBuf getOtherData() {
        return Unpooled.wrappedBuffer((byte[])this.cipherText);
    }

    public byte[] getPlainText() {
        return this.plainText;
    }
}

