/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.radius.common.tls.recordlayer;

import com.tplink.cdd.radius.common.tls.CipherSuite.TlsCipher;
import com.tplink.cdd.radius.common.tls.enums.AlertDescription;
import com.tplink.cdd.radius.common.tls.enums.AlertLevel;
import com.tplink.cdd.radius.common.tls.enums.RecordLayerType;
import com.tplink.cdd.radius.common.tls.recordlayer.RecordLayer;
import com.tplink.cdd.radius.common.utils.TlsUtil;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Alert
extends RecordLayer {
    private static final Logger log = LoggerFactory.getLogger(Alert.class);
    private AlertMessage alertMessage;

    protected Alert(ByteBuf byteBuf, TlsCipher tlsCipher) {
        super(RecordLayerType.ALERT, byteBuf);
        ByteBuf alert = byteBuf.readBytes((int)this.getLength());
        if (Objects.nonNull(tlsCipher)) {
            byte[] encryptedAlertMsg = ByteBufUtil.getBytes((ByteBuf)alert);
            byte[] inputAlertMsg = TlsUtil.decryptTlsText(tlsCipher, RecordLayerType.ALERT, encryptedAlertMsg);
            if (Objects.nonNull(inputAlertMsg) && Objects.equals(inputAlertMsg.length, 2)) {
                this.alertMessage = new AlertMessage(inputAlertMsg);
            }
        } else if (alert.readableBytes() == 2) {
            this.alertMessage = new AlertMessage(AlertLevel.fromIndex(alert.readByte()), AlertDescription.fromIndex(alert.readByte()));
        }
    }

    public AlertMessage getAlertMessage() {
        return this.alertMessage;
    }

    @Override
    protected ByteBuf getOtherData() {
        return null;
    }

    public static class AlertMessage {
        private AlertLevel level;
        private AlertDescription description;

        public AlertMessage(byte[] alertMessage) {
            this(AlertLevel.fromIndex(alertMessage[0]), AlertDescription.fromIndex(alertMessage[1]));
        }

        public AlertLevel getLevel() {
            return this.level;
        }

        public AlertDescription getDescription() {
            return this.description;
        }

        public AlertMessage(AlertLevel level, AlertDescription description) {
            this.level = level;
            this.description = description;
        }
    }
}

