/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.radius.common.tls.enums;

import java.util.Arrays;
import java.util.Objects;

public enum TlsVersion {
    V1_0(769, "TLS V1.0"),
    V1_1(770, "TLS V1.1"),
    V1_2(771, "TLS V1.2"),
    V1_3(772, "TLS V1.3");

    private final short index;
    private final String name;

    private TlsVersion(short index, String name) {
        this.index = index;
        this.name = name;
    }

    public static TlsVersion fromIndex(short index) {
        return Arrays.stream(TlsVersion.values()).filter(tlsVersion -> Objects.equals(tlsVersion.getIndex(), index)).findFirst().orElse(null);
    }

    public short getIndex() {
        return this.index;
    }

    public String getName() {
        return this.name;
    }
}

