/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.radius.common.tls.enums;

import java.util.Arrays;
import java.util.Objects;

public enum SignatureHashAlgorithm {
    RSA_PKCS1_SHA1(2, 1),
    RSA_PKCS1_SHA256(4, 1),
    RSA_PKCS1_SHA384(5, 1),
    RSA_PKCS1_SHA512(6, 1),
    SHA224_RSA(3, 1),
    ECDSA_SECP256R1_SHA256(4, 3),
    ECDSA_SECP384R1_SHA384(5, 3),
    ECDSA_SECP521R1_SHA3512(6, 3),
    ECDSA_SHA1(2, 3),
    SHA224_DSA(3, 2),
    SHA1_DSA(2, 2),
    SHA256_DSA(4, 2),
    SHA384_DSA(5, 2),
    SHA512_DSA(6, 2);

    private final byte hash;
    private final byte signature;

    private SignatureHashAlgorithm(byte hash, byte signature) {
        this.hash = hash;
        this.signature = signature;
    }

    public static SignatureHashAlgorithm fromHashAndSign(byte hash, byte signature) {
        return Arrays.stream(SignatureHashAlgorithm.values()).filter(obj -> Objects.equals(obj.getHash(), hash) && Objects.equals(obj.getSignature(), signature)).findFirst().orElse(null);
    }

    public byte getHash() {
        return this.hash;
    }

    public byte getSignature() {
        return this.signature;
    }
}

