/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.radius.common.tls.enums;

import java.util.Arrays;
import java.util.Objects;

public enum HashAlgorithm {
    NONE(0, "none"),
    MD5(1, "md5"),
    SHA1(2, "sha1"),
    SHA224(3, "sha224"),
    SHA256(4, "sha256"),
    SHA384(5, "sha384"),
    SHA512(6, "sha512");

    private final byte index;
    private final String name;

    private HashAlgorithm(byte index, String name) {
        this.index = index;
        this.name = name;
    }

    public static HashAlgorithm fromIndex(byte index) {
        return Arrays.stream(HashAlgorithm.values()).filter(hash -> Objects.equals(hash.getIndex(), index)).findFirst().orElse(null);
    }

    public byte getIndex() {
        return this.index;
    }

    public String getName() {
        return this.name;
    }
}

