/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.radius.common.tls.enums;

import java.util.Arrays;
import java.util.Objects;

public enum HandshakeType {
    CLIENT_HELLO(1, "client_hello"),
    SERVER_HELLO(2, "server_hello"),
    CERTIFICATE(11, "certificate"),
    SERVER_KEY_EXCHANGE(12, "server_key_exchange"),
    CERTIFICATE_REQUEST(13, "certificate_request"),
    SERVER_HELLO_DONE(14, "server hello done"),
    CERTIFICATE_VERIFY(15, "certificate_verify"),
    CLIENT_KEY_EXCHANGE(16, "client_key_exchange"),
    FINISHED(20, "finished");

    private final byte index;
    private final String name;

    private HandshakeType(byte index, String name) {
        this.index = index;
        this.name = name;
    }

    public static HandshakeType fromIndex(byte index) {
        return Arrays.stream(HandshakeType.values()).filter(handshakeType -> Objects.equals(handshakeType.getIndex(), index)).findFirst().orElse(null);
    }

    public byte getIndex() {
        return this.index;
    }

    public String getName() {
        return this.name;
    }
}

