/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.radius.common.tls.enums;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public enum CipherSuite {
    TLS_RSA_WITH_AES_128_CBC_SHA("TLS_RSA_WITH_AES_128_CBC_SHA", 47, 16, 1);

    public static final List<CipherSuite> SERVER_SUPPORT_CIPHER_SUITES;
    private final String name;
    private final short index;
    private final int cipherKeySize;
    private final int priority;

    private CipherSuite(String name, short index, int cipherKeySize, int priority) {
        this.name = name;
        this.index = index;
        this.cipherKeySize = cipherKeySize;
        this.priority = priority;
    }

    public static CipherSuite of(short index) {
        for (CipherSuite cipherSuite : CipherSuite.values()) {
            if (!Objects.equals(cipherSuite.getIndex(), index)) continue;
            return cipherSuite;
        }
        return null;
    }

    public static CipherSuite fromClientCipherSuites(List<Short> clientCipherSuiteList) {
        for (CipherSuite serverSupportCipherSuite : SERVER_SUPPORT_CIPHER_SUITES) {
            if (!clientCipherSuiteList.contains(serverSupportCipherSuite.getIndex())) continue;
            return serverSupportCipherSuite;
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public short getIndex() {
        return this.index;
    }

    public int getCipherKeySize() {
        return this.cipherKeySize;
    }

    public int getPriority() {
        return this.priority;
    }

    static {
        SERVER_SUPPORT_CIPHER_SUITES = Arrays.stream(CipherSuite.values()).sorted(Comparator.comparingInt(CipherSuite::getPriority)).collect(Collectors.toList());
    }
}

