/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.radius.common.tls.enums;

import java.util.Arrays;
import java.util.Objects;

public enum AlertDescription {
    CLOSE_NOTIFY(0, "close_notify"),
    UNEXPECTED_MESSAGE(10, "unexpected_message"),
    BAD_RECORD_MAC(20, "bad_record_mac"),
    DECRYPTION_FAILED(21, "decryption_failed"),
    RECORD_OVERFLOW(22, "record_overflow"),
    DECOMPRESSION_FAILURE(30, "decompression_failure"),
    HANDSHAKE_FAILURE(40, "handshake_failure"),
    BAD_CERTIFICATE(42, "bad_certificate"),
    UNSUPPORTED_CERTIFICATE(43, "unsupported_certificate"),
    CERTIFICATE_REVOKED(44, "certificate_revoked"),
    CERTIFICATE_EXPIRED(45, "certificate_expired"),
    CERTIFICATE_UNKNOWN(46, "certificate_unknown"),
    ILLEGAL_PARAMETER(47, "illegal_parameter"),
    UNKNOWN_CA(48, "unknown_ca"),
    ACCESS_DENIED(49, "access_denied"),
    DECODE_ERROR(50, "decode_error"),
    DECRYPT_ERROR(51, "decrypt_error"),
    EXPORT_RESTRICTION(60, "export_restriction"),
    PROTOCOL_VERSION(70, "protocol_version"),
    INSUFFICIENT_SECURITY(71, "insufficient_security"),
    INTERNAL_ERROR(80, "internal_error"),
    USER_CANCELED(90, "user_canceled"),
    NO_RENEGOTIATION(100, "no_renegotiation");

    private final byte index;
    private final String name;

    private AlertDescription(byte index, String name) {
        this.index = index;
        this.name = name;
    }

    public static AlertDescription fromIndex(byte index) {
        return Arrays.stream(AlertDescription.values()).filter(description -> Objects.equals(description.getIndex(), index)).findFirst().orElse(null);
    }

    public byte getIndex() {
        return this.index;
    }

    public String getName() {
        return this.name;
    }
}

