/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.radius.common.tls.dto;

import java.util.Arrays;

public class SecurityParameters {
    private byte[] masterSecret;
    private byte[] clientRandom;
    private byte[] serverRandom;

    public static SecurityParametersBuilder builder() {
        return new SecurityParametersBuilder();
    }

    public byte[] getMasterSecret() {
        return this.masterSecret;
    }

    public byte[] getClientRandom() {
        return this.clientRandom;
    }

    public byte[] getServerRandom() {
        return this.serverRandom;
    }

    public void setMasterSecret(byte[] masterSecret) {
        this.masterSecret = masterSecret;
    }

    public void setClientRandom(byte[] clientRandom) {
        this.clientRandom = clientRandom;
    }

    public void setServerRandom(byte[] serverRandom) {
        this.serverRandom = serverRandom;
    }

    public String toString() {
        return "SecurityParameters(masterSecret=" + Arrays.toString(this.getMasterSecret()) + ", clientRandom=" + Arrays.toString(this.getClientRandom()) + ", serverRandom=" + Arrays.toString(this.getServerRandom()) + ")";
    }

    public SecurityParameters() {
    }

    public SecurityParameters(byte[] masterSecret, byte[] clientRandom, byte[] serverRandom) {
        this.masterSecret = masterSecret;
        this.clientRandom = clientRandom;
        this.serverRandom = serverRandom;
    }

    public static class SecurityParametersBuilder {
        private byte[] masterSecret;
        private byte[] clientRandom;
        private byte[] serverRandom;

        SecurityParametersBuilder() {
        }

        public SecurityParametersBuilder masterSecret(byte[] masterSecret) {
            this.masterSecret = masterSecret;
            return this;
        }

        public SecurityParametersBuilder clientRandom(byte[] clientRandom) {
            this.clientRandom = clientRandom;
            return this;
        }

        public SecurityParametersBuilder serverRandom(byte[] serverRandom) {
            this.serverRandom = serverRandom;
            return this;
        }

        public SecurityParameters build() {
            return new SecurityParameters(this.masterSecret, this.clientRandom, this.serverRandom);
        }

        public String toString() {
            return "SecurityParameters.SecurityParametersBuilder(masterSecret=" + Arrays.toString(this.masterSecret) + ", clientRandom=" + Arrays.toString(this.clientRandom) + ", serverRandom=" + Arrays.toString(this.serverRandom) + ")";
        }
    }
}

