/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.radius.common.tls;

import com.tplink.cdd.radius.common.tls.CipherSuite.TlsCipher;
import com.tplink.cdd.radius.common.tls.TlsPacketException;
import com.tplink.cdd.radius.common.tls.enums.RecordLayerType;
import com.tplink.cdd.radius.common.tls.recordlayer.Alert;
import com.tplink.cdd.radius.common.tls.recordlayer.ApplicationData;
import com.tplink.cdd.radius.common.tls.recordlayer.ChangeCipherSpec;
import com.tplink.cdd.radius.common.tls.recordlayer.Handshake;
import com.tplink.cdd.radius.common.tls.recordlayer.RecordLayer;
import com.tplink.cdd.radius.common.tls.recordlayer.handshake.HandshakeProtocol;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class TlsPacket {
    private static final Logger log = LoggerFactory.getLogger(TlsPacket.class);
    private final List<RecordLayer> recordLayerList;

    public static TlsPacket fromByteBuf(ByteBuf byteBuf, TlsCipher tlsCipher) throws TlsPacketException {
        ArrayList<RecordLayer> recordLayerList = new ArrayList<RecordLayer>();
        while (byteBuf.isReadable()) {
            boolean finished = !CollectionUtils.isEmpty(recordLayerList) && Objects.equals((Object)((RecordLayer)recordLayerList.get(recordLayerList.size() - 1)).getType(), (Object)RecordLayerType.CHANGE_CIPHER_SPEC);
            RecordLayer recordLayer = RecordLayer.newInstance(byteBuf, tlsCipher, finished);
            recordLayerList.add(recordLayer);
        }
        return new TlsPacket(recordLayerList);
    }

    public ByteBuf toByteBuf() {
        ByteBuf byteBuf = Unpooled.buffer();
        this.recordLayerList.forEach(recordLayer -> byteBuf.writeBytes(recordLayer.toByteBuf()));
        return byteBuf;
    }

    public int getSize() {
        return this.toByteBuf().readableBytes();
    }

    public boolean containsAlert() {
        return this.recordLayerList.stream().anyMatch(recordLayer -> Objects.equals((Object)recordLayer.getType(), (Object)RecordLayerType.ALERT));
    }

    public boolean containsApplicationData() {
        return this.recordLayerList.stream().anyMatch(recordLayer -> Objects.equals((Object)recordLayer.getType(), (Object)RecordLayerType.APPLICATION_DATA));
    }

    public Alert.AlertMessage getAlertMessage() {
        for (RecordLayer recordLayer : this.recordLayerList) {
            if (!Objects.equals((Object)recordLayer.getType(), (Object)RecordLayerType.ALERT)) continue;
            Alert alert = (Alert)recordLayer;
            return alert.getAlertMessage();
        }
        log.error("Current TLS Packet do not contain alert message");
        return null;
    }

    public ChangeCipherSpec getChangeCipherSpec() {
        for (RecordLayer recordLayer : this.recordLayerList) {
            if (!Objects.equals((Object)recordLayer.getType(), (Object)RecordLayerType.CHANGE_CIPHER_SPEC)) continue;
            return (ChangeCipherSpec)recordLayer;
        }
        log.error("Current TLS Packet do not contain change cipher spec");
        return null;
    }

    public List<ApplicationData> getApplicationDataList() {
        return this.recordLayerList.stream().filter(recordLayer -> Objects.equals((Object)recordLayer.getType(), (Object)RecordLayerType.APPLICATION_DATA)).map(recordLayer -> (ApplicationData)recordLayer).collect(Collectors.toList());
    }

    public <T extends HandshakeProtocol> boolean containsHandshakeProtocol(Class<T> targetClazz) {
        return !Objects.isNull(this.getHandshakeProtocol(targetClazz));
    }

    public <T extends HandshakeProtocol> T getHandshakeProtocol(Class<T> targetClazz) {
        for (RecordLayer recordLayer : this.recordLayerList) {
            if (!Objects.equals((Object)RecordLayerType.HANDSHAKE, (Object)recordLayer.getType())) continue;
            Handshake handshake = (Handshake)recordLayer;
            for (HandshakeProtocol handshakeProtocol : handshake.getHandshakeProtocolList()) {
                if (!targetClazz.isInstance(handshakeProtocol)) continue;
                return (T)handshakeProtocol;
            }
        }
        log.warn("Current TLS Packet do not contain the handshake protocol type : {}", (Object)targetClazz.getSimpleName());
        return null;
    }

    public TlsPacket(List<RecordLayer> recordLayerList) {
        this.recordLayerList = recordLayerList;
    }
}

