/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.radius.common.tls.CipherSuite;

import com.tplink.cdd.radius.common.tls.enums.TlsVersion;
import com.tplink.cdd.radius.common.utils.TlsUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.KeyParameter;

public class TlsMac {
    private long seqNo;
    private final HMac mac;

    protected TlsMac(Digest digest, byte[] keyBlock, int offset, int len) {
        this.mac = new HMac(digest);
        this.mac.init((CipherParameters)new KeyParameter(keyBlock, offset, len));
        this.seqNo = 0L;
    }

    protected int getSize() {
        return this.mac.getMacSize();
    }

    protected byte[] calculateMac(short type, byte[] message, int offset, int len, TlsVersion tlsVersion) {
        ByteArrayOutputStream bosMac = new ByteArrayOutputStream(13);
        try {
            TlsUtil.writeUint64(this.seqNo++, bosMac);
            TlsUtil.writeUint8(type, bosMac);
            TlsUtil.writeVersion(bosMac, tlsVersion);
            TlsUtil.writeUint16(len, bosMac);
        }
        catch (IOException e) {
            throw new IllegalStateException("Internal error during mac calculation");
        }
        byte[] macHeader = bosMac.toByteArray();
        this.mac.update(macHeader, 0, macHeader.length);
        this.mac.update(message, offset, len);
        byte[] result = new byte[this.mac.getMacSize()];
        this.mac.doFinal(result, 0);
        return result;
    }
}

