/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.radius.common.tls.CipherSuite;

import com.tplink.cdd.radius.common.tls.CipherSuite.TlsCipher;
import com.tplink.cdd.radius.common.tls.CipherSuite.TlsMac;
import com.tplink.cdd.radius.common.tls.dto.SecurityParameters;
import com.tplink.cdd.radius.common.tls.enums.TlsVersion;
import com.tplink.cdd.radius.common.utils.CipherUtil;
import com.tplink.cdd.radius.common.utils.RandomUtil;
import java.io.IOException;
import java.security.SecureRandom;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TlsGenericCipher
implements TlsCipher {
    private static final Logger log = LoggerFactory.getLogger(TlsGenericCipher.class);
    private static final String KEY_BLOCK_LABEL = "key expansion";
    private static final String PEAP_MSKEY_LABEL = "client EAP encryption";
    private static final String TTLS_MSKEY_LABEL = "ttls keying material";
    private static final int MS_KEY_MATERIAL_LENGTH = 128;
    private final BlockCipher clientCipher;
    private final BlockCipher serverCipher;
    private final TlsMac clientMac;
    private final TlsMac serverMac;
    private final TlsVersion tlsVersion;
    private byte[] keyBlock;
    private int cipherKeySize;
    private final byte[] msPeapKeyMaterial;
    private final byte[] msTtlsKeyMaterial;

    public TlsGenericCipher(BlockCipher clientCipher, BlockCipher serverCipher, int cipherKeySize, Digest clientDigest, Digest serverDigest, SecurityParameters securityParameters, TlsVersion tlsVersion) {
        byte[] keyBlock;
        this.clientCipher = clientCipher;
        this.serverCipher = serverCipher;
        this.tlsVersion = tlsVersion;
        this.cipherKeySize = cipherKeySize;
        int clientMacSize = clientDigest.getDigestSize();
        int serverMacSize = serverDigest.getDigestSize();
        int clientIvSize = clientCipher.getBlockSize();
        int serverIvSize = serverCipher.getBlockSize();
        int keyBlockSize = clientMacSize + serverMacSize + cipherKeySize * 2 + clientIvSize + serverIvSize;
        if (tlsVersion == TlsVersion.V1_0 || tlsVersion == TlsVersion.V1_1) {
            keyBlock = CipherUtil.PRF(securityParameters.getMasterSecret(), KEY_BLOCK_LABEL, CipherUtil.concat(securityParameters.getServerRandom(), securityParameters.getClientRandom()), keyBlockSize);
            byte[] msPeapKeyMaterial = CipherUtil.PRF(securityParameters.getMasterSecret(), PEAP_MSKEY_LABEL, CipherUtil.concat(securityParameters.getClientRandom(), securityParameters.getServerRandom()), 128);
            byte[] msTtlsKeyMaterial = CipherUtil.PRF(securityParameters.getMasterSecret(), TTLS_MSKEY_LABEL, CipherUtil.concat(securityParameters.getClientRandom(), securityParameters.getServerRandom()), 128);
            this.msPeapKeyMaterial = msPeapKeyMaterial;
            this.msTtlsKeyMaterial = msTtlsKeyMaterial;
        } else {
            keyBlock = CipherUtil.PRF_SHA256(securityParameters.getMasterSecret(), KEY_BLOCK_LABEL, CipherUtil.concat(securityParameters.getServerRandom(), securityParameters.getClientRandom()), keyBlockSize);
            byte[] msPeapKeyMaterial = CipherUtil.PRF_SHA256(securityParameters.getMasterSecret(), PEAP_MSKEY_LABEL, CipherUtil.concat(securityParameters.getClientRandom(), securityParameters.getServerRandom()), 128);
            byte[] msTtlsKeyMaterial = CipherUtil.PRF_SHA256(securityParameters.getMasterSecret(), TTLS_MSKEY_LABEL, CipherUtil.concat(securityParameters.getClientRandom(), securityParameters.getServerRandom()), 128);
            this.msPeapKeyMaterial = msPeapKeyMaterial;
            this.msTtlsKeyMaterial = msTtlsKeyMaterial;
        }
        this.keyBlock = keyBlock;
        int offset = 0;
        this.clientMac = new TlsMac(clientDigest, keyBlock, offset, clientMacSize);
        this.serverMac = new TlsMac(serverDigest, keyBlock, offset += clientMacSize, serverMacSize);
        offset += serverMacSize;
        if (tlsVersion == TlsVersion.V1_0) {
            this.initCipher(false, clientCipher, keyBlock, cipherKeySize, offset, offset + cipherKeySize * 2);
            this.initCipher(true, serverCipher, keyBlock, cipherKeySize, offset += cipherKeySize, offset + cipherKeySize + clientIvSize);
        }
    }

    @Override
    public byte[] encodePlainText(short type, byte[] plainText, int offset, int len) throws IOException {
        int i;
        int blockSize = this.serverCipher.getBlockSize();
        int minPaddingSize = blockSize - (len + this.serverMac.getSize() + 1) % blockSize;
        int maxExtraPadBlocks = (255 - minPaddingSize) / blockSize;
        int actualExtraPadBlocks = this.chooseExtraPadBlocks(RandomUtil.createSecureRandom(), maxExtraPadBlocks);
        int paddingSize = minPaddingSize + actualExtraPadBlocks * blockSize;
        int totalSize = len + this.serverMac.getSize() + paddingSize + 1;
        byte[] outBuf = new byte[totalSize];
        System.arraycopy(plainText, offset, outBuf, 0, len);
        byte[] mac = this.serverMac.calculateMac(type, plainText, offset, len, this.tlsVersion);
        System.arraycopy(mac, 0, outBuf, len, mac.length);
        int padOffset = len + mac.length;
        for (i = 0; i <= paddingSize; ++i) {
            outBuf[i + padOffset] = (byte)paddingSize;
        }
        if (this.tlsVersion == TlsVersion.V1_0) {
            for (i = 0; i < totalSize; i += blockSize) {
                this.serverCipher.processBlock(outBuf, i, outBuf, i);
            }
            return outBuf;
        }
        byte[] serverIV = RandomUtil.randomBytes(this.serverCipher.getBlockSize());
        byte[] partKeyBlock = Arrays.copyOfRange((byte[])this.keyBlock, (int)0, (int)(this.clientMac.getSize() + this.serverMac.getSize() + this.cipherKeySize * 2 + this.clientCipher.getBlockSize()));
        byte[] newKeyBlock = CipherUtil.concat(partKeyBlock, serverIV);
        int keyOffset = this.clientMac.getSize() + this.serverMac.getSize() + this.cipherKeySize;
        this.initCipher(true, this.serverCipher, newKeyBlock, this.cipherKeySize, keyOffset, keyOffset + this.cipherKeySize + this.clientCipher.getBlockSize());
        for (int i2 = 0; i2 < totalSize; i2 += blockSize) {
            this.serverCipher.processBlock(outBuf, i2, outBuf, i2);
        }
        return CipherUtil.concat(serverIV, outBuf);
    }

    @Override
    public byte[] decodeCipherText(short type, byte[] receivedCipherText, int offset, int len) throws IOException {
        byte[] cipherText;
        int minLength = this.clientMac.getSize() + 1;
        int blockSize = this.clientCipher.getBlockSize();
        boolean decryptError = false;
        if (len < minLength) {
            throw new IOException("decode error : cipher text too short, length = " + len + ", mac size = " + minLength);
        }
        if (len % blockSize != 0) {
            throw new IOException("decode error : cipher text must be a multiple of blockSize =  " + blockSize);
        }
        if (this.tlsVersion == TlsVersion.V1_0) {
            cipherText = Arrays.copyOf((byte[])receivedCipherText, (int)receivedCipherText.length);
        } else {
            int clientIVLength = this.clientCipher.getBlockSize();
            byte[] clientIV = Arrays.copyOfRange((byte[])receivedCipherText, (int)0, (int)clientIVLength);
            cipherText = Arrays.copyOfRange((byte[])receivedCipherText, (int)blockSize, (int)receivedCipherText.length);
            int offset1 = this.clientMac.getSize() + this.serverMac.getSize();
            byte[] newKeyBlock = Arrays.copyOf((byte[])this.keyBlock, (int)this.keyBlock.length);
            for (int i = 0; i < clientIVLength; ++i) {
                newKeyBlock[offset1 + 2 * this.cipherKeySize + i] = clientIV[i];
            }
            len -= clientIVLength;
            this.initCipher(false, this.clientCipher, newKeyBlock, this.cipherKeySize, offset1, offset1 + this.cipherKeySize * 2);
        }
        for (int i = 0; i < len; i += blockSize) {
            this.clientCipher.processBlock(cipherText, i + offset, cipherText, i + offset);
        }
        int lastByteOffset = offset + len - 1;
        byte paddingSizeByte = cipherText[lastByteOffset];
        int paddingSize = paddingSizeByte & 0xFF;
        int maxPaddingSize = len - minLength;
        if (paddingSize > maxPaddingSize) {
            decryptError = true;
            paddingSize = 0;
        } else {
            int diff = 0;
            for (int i = lastByteOffset - paddingSize; i < lastByteOffset; ++i) {
                diff = (byte)(diff | cipherText[i] ^ paddingSizeByte);
            }
            if (diff != 0) {
                decryptError = true;
                paddingSize = 0;
            }
        }
        int plainTextLength = len - minLength - paddingSize;
        byte[] calculatedMac = this.clientMac.calculateMac(type, cipherText, offset, plainTextLength, this.tlsVersion);
        byte[] decryptedMac = new byte[calculatedMac.length];
        System.arraycopy(cipherText, offset + plainTextLength, decryptedMac, 0, calculatedMac.length);
        if (!Arrays.constantTimeAreEqual((byte[])calculatedMac, (byte[])decryptedMac)) {
            decryptError = true;
        }
        if (decryptError) {
            throw new IOException("decode error : it is safe to fail");
        }
        byte[] plainText = new byte[plainTextLength];
        System.arraycopy(cipherText, offset, plainText, 0, plainTextLength);
        return plainText;
    }

    private void initCipher(boolean forEncryption, BlockCipher cipher, byte[] keyBlock, int keySize, int keyOffset, int ivOffset) {
        KeyParameter keyParameter = new KeyParameter(keyBlock, keyOffset, keySize);
        ParametersWithIV parametersWithIv = new ParametersWithIV((CipherParameters)keyParameter, keyBlock, ivOffset, cipher.getBlockSize());
        cipher.init(forEncryption, (CipherParameters)parametersWithIv);
    }

    private int chooseExtraPadBlocks(SecureRandom r, int max) {
        int x = r.nextInt();
        int n = this.lowestBitSet(x);
        return Math.min(n, max);
    }

    private int lowestBitSet(int x) {
        if (x == 0) {
            return 32;
        }
        int n = 0;
        while ((x & 1) == 0) {
            ++n;
            x >>= 1;
        }
        return n;
    }

    public BlockCipher getClientCipher() {
        return this.clientCipher;
    }

    public BlockCipher getServerCipher() {
        return this.serverCipher;
    }

    public TlsMac getClientMac() {
        return this.clientMac;
    }

    public TlsMac getServerMac() {
        return this.serverMac;
    }

    @Override
    public TlsVersion getTlsVersion() {
        return this.tlsVersion;
    }

    public byte[] getKeyBlock() {
        return this.keyBlock;
    }

    public int getCipherKeySize() {
        return this.cipherKeySize;
    }

    public byte[] getMsPeapKeyMaterial() {
        return this.msPeapKeyMaterial;
    }

    public byte[] getMsTtlsKeyMaterial() {
        return this.msTtlsKeyMaterial;
    }
}

