/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.radius.common.tls.CipherSuite;

import com.tplink.cdd.radius.common.tls.dto.SecurityParameters;
import com.tplink.cdd.radius.common.tls.enums.CipherSuite;
import com.tplink.cdd.radius.common.tls.enums.TlsVersion;
import com.tplink.cdd.radius.common.utils.TlsUtil;
import java.io.IOException;

public interface TlsCipher {
    public byte[] encodePlainText(short var1, byte[] var2, int var3, int var4) throws IOException;

    public byte[] decodeCipherText(short var1, byte[] var2, int var3, int var4) throws IOException;

    public static TlsCipher create(CipherSuite cipherSuite, SecurityParameters securityParameters, TlsVersion tlsVersion) {
        switch (cipherSuite) {
            case TLS_RSA_WITH_AES_128_CBC_SHA: {
                return TlsUtil.createAESCipher(cipherSuite.getCipherKeySize(), securityParameters, tlsVersion);
            }
        }
        return null;
    }

    public TlsVersion getTlsVersion();
}

