/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.radius.common.packet.util;

import com.tplink.cdd.radius.common.RadiusPacketException;
import com.tplink.cdd.radius.common.attribute.AttributeTemplate;
import com.tplink.cdd.radius.common.attribute.type.RadiusAttribute;
import com.tplink.cdd.radius.common.packet.RadiusPacket;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public interface MessageAuthSupport<T extends RadiusPacket<T>>
extends RadiusPacket<T> {
    public static final Logger msgAuthLogger = LogManager.getLogger();
    public static final int MESSAGE_AUTHENTICATOR = 80;

    public static byte[] calcMessageAuthInput(RadiusPacket<?> packet, byte[] requestAuth) {
        ByteBuf buf = Unpooled.buffer().writeByte((int)packet.getType()).writeByte((int)packet.getId()).writeShort(0).writeBytes(requestAuth);
        for (RadiusAttribute attribute : packet.getAttributes()) {
            if (attribute.getVendorId() == -1 && attribute.getType() == 80) {
                buf.writeByte(80).writeByte(18).writeBytes(new byte[16]);
                continue;
            }
            buf.writeBytes(attribute.toByteArray());
        }
        return buf.setShort(2, buf.readableBytes()).copy().array();
    }

    public static Mac getHmacMd5(String key) {
        try {
            String HMAC_MD5 = "HmacMD5";
            SecretKeySpec secretKeySpec = new SecretKeySpec(key.getBytes(), "HmacMD5");
            Mac mac = Mac.getInstance("HmacMD5");
            mac.init(secretKeySpec);
            return mac;
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(e);
        }
    }

    default public void verifyMessageAuth(String sharedSecret, byte[] requestAuth) throws RadiusPacketException {
        List<RadiusAttribute> msgAuthAttr = this.filterAttributes(80);
        if (msgAuthAttr.isEmpty()) {
            return;
        }
        if (msgAuthAttr.size() > 1) {
            throw new RadiusPacketException("Message-Authenticator check failed - should have at most one count, has " + msgAuthAttr.size());
        }
        byte[] messageAuth = msgAuthAttr.get(0).getValue();
        if (messageAuth.length != 16) {
            throw new RadiusPacketException("Message-Authenticator check failed - must be 16 octets, actual " + messageAuth.length);
        }
        if (!Arrays.equals(messageAuth, this.computeMessageAuth(this, sharedSecret, requestAuth))) {
            boolean decodedAlready = this.getAttributes().stream().filter(a -> a.getAttributeTemplate().map(AttributeTemplate::encryptEnabled).orElse(false)).anyMatch(a -> !a.isEncoded());
            if (decodedAlready) {
                msgAuthLogger.info("Skipping Message-Authenticator check - attributes have been decrypted already");
            } else {
                throw new RadiusPacketException("Message-Authenticator check failed");
            }
        }
    }

    default public byte[] computeMessageAuth(RadiusPacket<?> packet, String sharedSecret, byte[] requestAuth) {
        Objects.requireNonNull(requestAuth, "Request Authenticator cannot be null for Message-Authenticator hashing");
        byte[] messageAuthInput = MessageAuthSupport.calcMessageAuthInput(packet, requestAuth);
        return MessageAuthSupport.getHmacMd5(sharedSecret).doFinal(messageAuthInput);
    }

    default public T encodeMessageAuth(String sharedSecret, byte[] requestAuth) throws RadiusPacketException {
        ByteBuffer buffer = ByteBuffer.allocate(16);
        RadiusAttribute attribute = this.getDictionary().createAttribute(-1, 80, (byte)0, buffer.array());
        List<RadiusAttribute> attributes = this.filterAttributes((RadiusAttribute a) -> a.getType() != 80);
        attributes.add(0, attribute);
        RadiusPacket newPacket = (RadiusPacket)this.withAttributes(attributes);
        buffer.put(this.computeMessageAuth(newPacket, sharedSecret, requestAuth));
        return (T)newPacket;
    }
}

