/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.radius.common.packet.response;

import com.tplink.cdd.radius.common.RadiusPacketException;
import com.tplink.cdd.radius.common.attribute.AttributeHolder;
import com.tplink.cdd.radius.common.attribute.type.RadiusAttribute;
import com.tplink.cdd.radius.common.dictionary.Dictionary;
import com.tplink.cdd.radius.common.packet.RadiusPacket;
import com.tplink.cdd.radius.common.packet.response.AccessResponse;
import com.tplink.cdd.radius.common.packet.response.GenericResponse;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.socket.DatagramPacket;
import java.util.List;

public interface RadiusResponse
extends RadiusPacket<RadiusResponse> {
    public static RadiusResponse create(Dictionary dictionary, ByteBuf header, List<RadiusAttribute> attributes) throws RadiusPacketException {
        switch (header.getByte(0)) {
            case 2: {
                return new AccessResponse.Accept(dictionary, header, attributes);
            }
            case 3: {
                return new AccessResponse.Reject(dictionary, header, attributes);
            }
            case 11: {
                return new AccessResponse.Challenge(dictionary, header, attributes);
            }
        }
        return new GenericResponse(dictionary, header, attributes);
    }

    public static RadiusResponse create(Dictionary dictionary, byte type, byte id, byte[] authenticator, List<RadiusAttribute> attributes) throws RadiusPacketException {
        ByteBuf header = RadiusPacket.buildHeader(type, id, authenticator, attributes);
        return RadiusResponse.create(dictionary, header, attributes);
    }

    public static RadiusResponse fromDatagram(Dictionary dictionary, DatagramPacket datagram) throws RadiusPacketException {
        return RadiusResponse.fromByteBuf(dictionary, Unpooled.unreleasableBuffer((ByteBuf)Unpooled.copiedBuffer((ByteBuf)((ByteBuf)datagram.content()))));
    }

    public static RadiusResponse fromByteBuf(Dictionary dictionary, ByteBuf byteBuf) throws RadiusPacketException {
        return RadiusResponse.create(dictionary, RadiusPacket.readHeader(byteBuf), AttributeHolder.readAttributes(dictionary, -1, byteBuf));
    }

    public RadiusResponse encodeResponse(String var1, byte[] var2) throws RadiusPacketException;

    public RadiusResponse decodeResponse(String var1, byte[] var2) throws RadiusPacketException;
}

