/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.radius.common.packet.response;

import com.tplink.cdd.radius.common.RadiusPacketException;
import com.tplink.cdd.radius.common.attribute.type.RadiusAttribute;
import com.tplink.cdd.radius.common.dictionary.Dictionary;
import com.tplink.cdd.radius.common.enums.UserAuthCategory;
import com.tplink.cdd.radius.common.packet.response.GenericResponse;
import com.tplink.cdd.radius.common.packet.response.RadiusResponse;
import com.tplink.cdd.radius.common.packet.util.MessageAuthSupport;
import io.netty.buffer.ByteBuf;
import java.util.List;

public class AccessResponse
extends GenericResponse
implements MessageAuthSupport<RadiusResponse> {
    private UserAuthCategory userAuthCategory;

    private AccessResponse(Dictionary dictionary, ByteBuf header, List<RadiusAttribute> attributes) throws RadiusPacketException {
        super(dictionary, header, attributes);
    }

    @Override
    public RadiusResponse encodeResponse(String sharedSecret, byte[] requestAuth) throws RadiusPacketException {
        RadiusResponse response = (RadiusResponse)((AccessResponse)this.withAttributes((List)this.encodeAttributes(requestAuth, sharedSecret))).encodeMessageAuth(sharedSecret, requestAuth);
        byte[] auth = response.genHashedAuth(sharedSecret, requestAuth);
        return (RadiusResponse)this.withAuthAttributes(auth, response.getAttributes());
    }

    @Override
    public RadiusResponse decodeResponse(String sharedSecret, byte[] requestAuth) throws RadiusPacketException {
        this.verifyMessageAuth(sharedSecret, requestAuth);
        return super.decodeResponse(sharedSecret, requestAuth);
    }

    private static void checkType(byte allowed, ByteBuf header) {
        byte type = header.getByte(0);
        if (type != allowed) {
            throw new IllegalArgumentException("First octet must be " + allowed + ", actual: " + type);
        }
    }

    public UserAuthCategory getUserAuthCategory() {
        return this.userAuthCategory;
    }

    public void setUserAuthCategory(UserAuthCategory userAuthCategory) {
        this.userAuthCategory = userAuthCategory;
    }

    public static class Challenge
    extends AccessResponse {
        public Challenge(Dictionary dictionary, ByteBuf header, List<RadiusAttribute> attributes) throws RadiusPacketException {
            super(dictionary, header, attributes);
            AccessResponse.checkType((byte)11, header);
        }
    }

    public static class Reject
    extends AccessResponse {
        public Reject(Dictionary dictionary, ByteBuf header, List<RadiusAttribute> attributes) throws RadiusPacketException {
            super(dictionary, header, attributes);
            AccessResponse.checkType((byte)3, header);
        }
    }

    public static class Accept
    extends AccessResponse {
        public Accept(Dictionary dictionary, ByteBuf header, List<RadiusAttribute> attributes) throws RadiusPacketException {
            super(dictionary, header, attributes);
            AccessResponse.checkType((byte)2, header);
        }
    }
}

