/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.radius.common.packet.request;

import com.tplink.cdd.radius.common.RadiusPacketException;
import com.tplink.cdd.radius.common.attribute.AttributeHolder;
import com.tplink.cdd.radius.common.attribute.type.RadiusAttribute;
import com.tplink.cdd.radius.common.dictionary.Dictionary;
import com.tplink.cdd.radius.common.packet.RadiusPacket;
import com.tplink.cdd.radius.common.packet.request.AccessRequest;
import com.tplink.cdd.radius.common.packet.request.AccountingRequest;
import com.tplink.cdd.radius.common.packet.request.GenericRequest;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.socket.DatagramPacket;
import java.util.List;

public interface RadiusRequest
extends RadiusPacket<RadiusRequest> {
    public static RadiusRequest create(Dictionary dictionary, ByteBuf header, List<RadiusAttribute> attributes) throws RadiusPacketException {
        switch (header.getByte(0)) {
            case 1: {
                return AccessRequest.create(dictionary, header, attributes);
            }
            case 4: {
                return new AccountingRequest(dictionary, header, attributes);
            }
        }
        return new GenericRequest(dictionary, header, attributes);
    }

    public static RadiusRequest create(Dictionary dictionary, byte type, byte id, byte[] authenticator, List<RadiusAttribute> attributes) throws RadiusPacketException {
        ByteBuf header = RadiusPacket.buildHeader(type, id, authenticator, attributes);
        return RadiusRequest.create(dictionary, header, attributes);
    }

    public static RadiusRequest fromDatagram(Dictionary dictionary, DatagramPacket datagram) throws RadiusPacketException {
        return RadiusRequest.fromByteBuf(dictionary, Unpooled.unreleasableBuffer((ByteBuf)Unpooled.copiedBuffer((ByteBuf)((ByteBuf)datagram.content()))));
    }

    public static RadiusRequest fromByteBuf(Dictionary dictionary, ByteBuf byteBuf) throws RadiusPacketException {
        return RadiusRequest.create(dictionary, RadiusPacket.readHeader(byteBuf), AttributeHolder.readAttributes(dictionary, -1, byteBuf));
    }

    public RadiusRequest encodeRequest(String var1) throws RadiusPacketException;

    public RadiusRequest decodeRequest(String var1) throws RadiusPacketException;
}

