/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.radius.common.packet.request;

import com.tplink.cdd.radius.common.RadiusPacketException;
import com.tplink.cdd.radius.common.attribute.type.RadiusAttribute;
import com.tplink.cdd.radius.common.dictionary.Dictionary;
import com.tplink.cdd.radius.common.enums.RadiusAvp;
import com.tplink.cdd.radius.common.packet.request.GenericRequest;
import com.tplink.cdd.radius.common.packet.request.RadiusRequest;
import com.tplink.cdd.radius.common.packet.util.MessageAuthSupport;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class CoaDmRequest
extends GenericRequest
implements MessageAuthSupport<RadiusRequest> {
    private static final Set<Integer> BASIC_ATTRS = new HashSet<Integer>(Arrays.asList(RadiusAvp.ACCT_SESSION_ID.getIndex(), RadiusAvp.CALLING_STATION_ID.getIndex(), RadiusAvp.FRAMED_IP_ADDRESS.getIndex(), RadiusAvp.USER_NAME.getIndex()));

    protected CoaDmRequest(Dictionary dictionary, ByteBuf header, List<RadiusAttribute> attributes) throws RadiusPacketException {
        super(dictionary, header, attributes);
        Set detectedAttr = attributes.stream().map(RadiusAttribute::getType).filter(BASIC_ATTRS::contains).collect(Collectors.toSet());
        if (detectedAttr.isEmpty()) {
            throw new RadiusPacketException("lock enough radius attrs of CoA/DM packet construction");
        }
    }
}

