/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.radius.common.packet.request;

import com.tplink.cdd.radius.common.RadiusPacketException;
import com.tplink.cdd.radius.common.attribute.type.RadiusAttribute;
import com.tplink.cdd.radius.common.dictionary.Dictionary;
import com.tplink.cdd.radius.common.packet.RadiusPacket;
import com.tplink.cdd.radius.common.packet.request.AccessRequest;
import com.tplink.cdd.radius.common.packet.request.RadiusRequest;
import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class AccessRequestPap
extends AccessRequest {
    public AccessRequestPap(Dictionary dictionary, ByteBuf header, List<RadiusAttribute> attributes) throws RadiusPacketException {
        super(dictionary, header, attributes);
    }

    static AccessRequest withPassword(AccessRequest request, String password) throws RadiusPacketException {
        List<RadiusAttribute> attributes = AccessRequestPap.withPasswordAttribute(request.getDictionary(), request.getAttributes(), password);
        ByteBuf header = RadiusPacket.buildHeader(request.getType(), request.getId(), request.getAuthenticator(), attributes);
        return AccessRequestPap.create(request.getDictionary(), header, attributes);
    }

    private static List<RadiusAttribute> withPasswordAttribute(Dictionary dictionary, List<RadiusAttribute> attributes, String password) {
        List<RadiusAttribute> newAttributes = attributes.stream().filter(a -> a.getVendorId() != -1 || a.getType() != 2).collect(Collectors.toList());
        newAttributes.add(dictionary.createAttribute(-1, 2, password.getBytes(StandardCharsets.UTF_8)));
        return newAttributes;
    }

    public Optional<String> getPassword() {
        return this.getAttribute(-1, 2).map(RadiusAttribute::getValue).map(v -> new String((byte[])v, StandardCharsets.UTF_8).trim());
    }

    @Override
    public RadiusRequest encodeRequest(String sharedSecret) throws RadiusPacketException {
        this.checkUserPassword();
        return super.encodeRequest(sharedSecret);
    }

    @Override
    public RadiusRequest decodeRequest(String sharedSecret) throws RadiusPacketException {
        this.checkUserPassword();
        return super.decodeRequest(sharedSecret);
    }

    private void checkUserPassword() throws RadiusPacketException {
        int count = this.filterAttributes(2).size();
        if (count != 1) {
            throw new RadiusPacketException("AccessRequest (PAP) should have exactly one User-Password attribute, has " + count);
        }
    }
}

