/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.radius.common.packet.request;

import com.tplink.cdd.radius.common.RadiusPacketException;
import com.tplink.cdd.radius.common.attribute.type.RadiusAttribute;
import com.tplink.cdd.radius.common.dictionary.Dictionary;
import com.tplink.cdd.radius.common.packet.request.AccessRequest;
import com.tplink.cdd.radius.common.packet.request.RadiusRequest;
import io.netty.buffer.ByteBuf;
import java.util.List;

public class AccessRequestNoAuth
extends AccessRequest {
    public AccessRequestNoAuth(Dictionary dictionary, ByteBuf header, List<RadiusAttribute> attributes) throws RadiusPacketException {
        super(dictionary, header, attributes);
    }

    @Override
    public RadiusRequest encodeRequest(String sharedSecret) throws RadiusPacketException {
        RadiusRequest radiusRequest = super.encodeRequest(sharedSecret);
        AccessRequestNoAuth.checkMessageAuth(radiusRequest.getAttributes());
        return radiusRequest;
    }

    @Override
    public RadiusRequest decodeRequest(String sharedSecret) throws RadiusPacketException {
        AccessRequestNoAuth.checkMessageAuth(this.getAttributes());
        return super.decodeRequest(sharedSecret);
    }

    private static void checkMessageAuth(List<RadiusAttribute> attributes) {
        long count = attributes.stream().filter(a -> a.getType() == 80).count();
        if (count != 1L) {
            logger.warn("AccessRequest without one of User-Password/CHAP-Password/ARAP-Password/EAP-Message should contain a Message-Authenticator");
        }
    }
}

