/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.radius.common.packet.request;

import com.tplink.cdd.radius.common.RadiusPacketException;
import com.tplink.cdd.radius.common.attribute.type.RadiusAttribute;
import com.tplink.cdd.radius.common.dictionary.Dictionary;
import com.tplink.cdd.radius.common.eap.EapPacketException;
import com.tplink.cdd.radius.common.eap.packet.BaseEapPacket;
import com.tplink.cdd.radius.common.eap.packet.EapResponse;
import com.tplink.cdd.radius.common.packet.request.AccessRequest;
import com.tplink.cdd.radius.common.packet.request.RadiusRequest;
import io.netty.buffer.ByteBuf;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessRequestEap
extends AccessRequest {
    private static final Logger log = LoggerFactory.getLogger(AccessRequestEap.class);
    private EapResponse eapResponse;

    public AccessRequestEap(Dictionary dictionary, ByteBuf header, List<RadiusAttribute> attributes) throws RadiusPacketException {
        super(dictionary, header, attributes);
    }

    @Override
    public RadiusRequest encodeRequest(String sharedSecret) throws RadiusPacketException {
        this.validateEapAttributes();
        return super.encodeRequest(sharedSecret);
    }

    @Override
    public RadiusRequest decodeRequest(String sharedSecret) throws RadiusPacketException {
        EapResponse eapResponse;
        List<RadiusAttribute> eapMessageList = this.validateEapAttributes();
        try {
            eapResponse = (EapResponse)BaseEapPacket.fromEapMessageList(eapMessageList);
        }
        catch (EapPacketException e) {
            log.warn("Exception found when parsing EAP-Message attribute", (Throwable)e);
            throw new RadiusPacketException("Exception found when parsing EAP-Message attribute");
        }
        List<RadiusAttribute> messageAuthAttr = this.filterAttributes(80);
        if (messageAuthAttr.size() != 1) {
            throw new RadiusPacketException("AccessRequest (EAP) should have exactly one Message-Authenticator attribute, has " + messageAuthAttr.size());
        }
        AccessRequestEap accessRequestEap = (AccessRequestEap)super.decodeRequest(sharedSecret);
        accessRequestEap.setEapResponse(eapResponse);
        return accessRequestEap;
    }

    public EapResponse getEapResponse() {
        return this.eapResponse;
    }

    public void setEapResponse(EapResponse eapResponse) {
        this.eapResponse = eapResponse;
    }

    private List<RadiusAttribute> validateEapAttributes() throws RadiusPacketException {
        List<RadiusAttribute> eapMessageAttr = this.filterAttributes(79);
        if (eapMessageAttr.isEmpty()) {
            throw new RadiusPacketException("AccessRequest (EAP) must have at least one EAP-Message attribute");
        }
        return eapMessageAttr;
    }
}

