/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.radius.common.packet.request;

import com.tplink.cdd.radius.common.RadiusPacketException;
import com.tplink.cdd.radius.common.attribute.type.RadiusAttribute;
import com.tplink.cdd.radius.common.dictionary.Dictionary;
import com.tplink.cdd.radius.common.packet.RadiusPacket;
import com.tplink.cdd.radius.common.packet.request.AccessRequest;
import com.tplink.cdd.radius.common.packet.request.RadiusRequest;
import io.netty.buffer.ByteBuf;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class AccessRequestChap
extends AccessRequest {
    private static final byte CHAP_CHALLENGE = 60;

    public AccessRequestChap(Dictionary dictionary, ByteBuf header, List<RadiusAttribute> attributes) throws RadiusPacketException {
        super(dictionary, header, attributes);
    }

    static AccessRequest withPassword(AccessRequest request, String password) throws RadiusPacketException {
        List<RadiusAttribute> attributes = AccessRequestChap.withPasswordAttribute(request.getDictionary(), request.getAttributes(), password);
        ByteBuf header = RadiusPacket.buildHeader(request.getType(), request.getId(), request.getAuthenticator(), attributes);
        return AccessRequestChap.create(request.getDictionary(), header, attributes);
    }

    private static List<RadiusAttribute> withPasswordAttribute(Dictionary dictionary, List<RadiusAttribute> attributes, String password) {
        if (password == null || password.isEmpty()) {
            throw new IllegalArgumentException("Could not encode CHAP attributes, password not set");
        }
        byte[] challenge = AccessRequestChap.random16bytes();
        List<RadiusAttribute> newAttributes = attributes.stream().filter(a -> !(a.getVendorId() == -1 && a.getType() == 3 || a.getVendorId() == -1 && a.getType() == 60)).collect(Collectors.toList());
        newAttributes.add(dictionary.createAttribute(-1, 60, challenge));
        newAttributes.add(dictionary.createAttribute(-1, 3, AccessRequestChap.computeChapPassword((byte)RANDOM.nextInt(256), password, challenge)));
        return newAttributes;
    }

    @Override
    public RadiusRequest encodeRequest(String sharedSecret) throws RadiusPacketException {
        this.validateChapAttributes();
        return super.encodeRequest(sharedSecret);
    }

    @Override
    public RadiusRequest decodeRequest(String sharedSecret) throws RadiusPacketException {
        this.validateChapAttributes();
        return super.decodeRequest(sharedSecret);
    }

    private static byte[] computeChapPassword(byte chapId, String plaintextPw, byte[] chapChallenge) {
        MessageDigest md5 = RadiusPacket.getMd5Digest();
        md5.update(chapId);
        md5.update(plaintextPw.getBytes(StandardCharsets.UTF_8));
        md5.update(chapChallenge);
        return ByteBuffer.allocate(17).put(chapId).put(md5.digest()).array();
    }

    public boolean checkPassword(String password) {
        if (password == null || password.isEmpty()) {
            logger.warn("Plaintext password to check against is empty");
            return false;
        }
        byte[] chapChallenge = this.getAttribute(60).map(RadiusAttribute::getValue).orElse(this.getAuthenticator());
        byte[] chapPassword = this.getAttribute(3).map(RadiusAttribute::getValue).orElse(null);
        if (chapPassword == null || chapPassword.length != 17) {
            logger.warn("CHAP-Password must be 17 bytes");
            return false;
        }
        return Arrays.equals(chapPassword, AccessRequestChap.computeChapPassword(chapPassword[0], password, chapChallenge));
    }

    private void validateChapAttributes() throws RadiusPacketException {
        int count = this.filterAttributes(3).size();
        if (count != 1) {
            throw new RadiusPacketException("AccessRequest (CHAP) should have exactly one CHAP-Password attribute, has " + count);
        }
    }
}

