/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.radius.common.packet.request;

import com.tplink.cdd.radius.common.RadiusPacketException;
import com.tplink.cdd.radius.common.attribute.type.RadiusAttribute;
import com.tplink.cdd.radius.common.dictionary.Dictionary;
import com.tplink.cdd.radius.common.packet.RadiusPacket;
import com.tplink.cdd.radius.common.packet.request.AccessRequestArap;
import com.tplink.cdd.radius.common.packet.request.AccessRequestChap;
import com.tplink.cdd.radius.common.packet.request.AccessRequestEap;
import com.tplink.cdd.radius.common.packet.request.AccessRequestNoAuth;
import com.tplink.cdd.radius.common.packet.request.AccessRequestPap;
import com.tplink.cdd.radius.common.packet.request.GenericRequest;
import com.tplink.cdd.radius.common.packet.request.RadiusRequest;
import com.tplink.cdd.radius.common.packet.util.MessageAuthSupport;
import io.netty.buffer.ByteBuf;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AccessRequest
extends GenericRequest
implements MessageAuthSupport<RadiusRequest> {
    protected static final Logger logger = LogManager.getLogger();
    protected static final SecureRandom RANDOM = new SecureRandom();
    protected static final int USER_PASSWORD = 2;
    protected static final int CHAP_PASSWORD = 3;
    protected static final int EAP_MESSAGE = 79;
    protected static final int ARAP_PASSWORD = 70;
    private static final Set<Integer> AUTH_ATTRS = new HashSet<Integer>(Arrays.asList(2, 3, 70, 79));

    protected AccessRequest(Dictionary dictionary, ByteBuf header, List<RadiusAttribute> attributes) throws RadiusPacketException {
        super(dictionary, header, attributes);
        byte type = header.getByte(0);
        if (type != 1) {
            throw new IllegalArgumentException("First octet must be 1, actual: " + type);
        }
    }

    static AccessRequest create(Dictionary dictionary, ByteBuf header, List<RadiusAttribute> attributes) throws RadiusPacketException {
        return AccessRequest.lookupAuthType(attributes).newInstance(dictionary, header, attributes);
    }

    private static AccessRequestFactory lookupAuthType(List<RadiusAttribute> attributes) {
        Set detectedAuth = attributes.stream().map(RadiusAttribute::getType).filter(AUTH_ATTRS::contains).collect(Collectors.toSet());
        if (detectedAuth.isEmpty()) {
            logger.debug("No auth attributes found, inferring NoAuth");
            return AccessRequestNoAuth::new;
        }
        if (detectedAuth.size() > 1) {
            logger.warn("Identified multiple auth mechanisms, inferring NoAuth");
            return AccessRequestNoAuth::new;
        }
        int authType = (Integer)detectedAuth.iterator().next();
        switch (authType) {
            case 79: {
                logger.debug("Inferring AccessRequest as EAP");
                return AccessRequestEap::new;
            }
            case 3: {
                logger.debug("Inferring AccessRequest as CHAP");
                return AccessRequestChap::new;
            }
            case 2: {
                logger.debug("Inferring AccessRequest as PAP");
                return AccessRequestPap::new;
            }
            case 70: {
                logger.debug("Inferring AccessRequest as ARAP");
                return AccessRequestArap::new;
            }
        }
        logger.warn("Cannot process authType {}, defaulting to NoAuth", (Object)authType);
        return AccessRequestNoAuth::new;
    }

    protected static byte[] random16bytes() {
        byte[] randomBytes = new byte[16];
        RANDOM.nextBytes(randomBytes);
        return randomBytes;
    }

    @Override
    protected byte[] genAuth(String sharedSecret) {
        return this.getAuthenticator() == null ? AccessRequest.random16bytes() : this.getAuthenticator();
    }

    public AccessRequest withChapPassword(String password) throws RadiusPacketException {
        return AccessRequestChap.withPassword(this.withoutAuths(), password);
    }

    public AccessRequest withPapPassword(String password) throws RadiusPacketException {
        return AccessRequestPap.withPassword(this.withoutAuths(), password);
    }

    private AccessRequest withoutAuths() throws RadiusPacketException {
        return this.withAttributes((List)this.filterAttributes((RadiusAttribute a) -> a.getVendorId() != -1 || !AUTH_ATTRS.contains(a.getType())));
    }

    @Override
    public RadiusRequest encodeRequest(String sharedSecret) throws RadiusPacketException {
        if (sharedSecret == null || sharedSecret.isEmpty()) {
            throw new IllegalArgumentException("Shared secret cannot be null/empty");
        }
        byte[] auth = this.genAuth(sharedSecret);
        return (RadiusRequest)this.withAuthAttributes(auth, (List)this.encodeAttributes(auth, sharedSecret)).encodeMessageAuth(sharedSecret, auth);
    }

    @Override
    public RadiusRequest decodeRequest(String sharedSecret) throws RadiusPacketException {
        byte[] auth = this.getAuthenticator();
        if (auth == null) {
            throw new RadiusPacketException("Authenticator check failed - authenticator missing");
        }
        if (auth.length != 16) {
            throw new RadiusPacketException("Authenticator check failed - authenticator must be 16 octets, actual " + auth.length);
        }
        this.verifyMessageAuth(sharedSecret, this.getAuthenticator());
        return this.withAttributes((List)this.decodeAttributes(this.getAuthenticator(), sharedSecret));
    }

    @Override
    public AccessRequest withAttributes(List<RadiusAttribute> attributes) throws RadiusPacketException {
        return this.withAuthAttributes(this.getAuthenticator(), (List)attributes);
    }

    @Override
    public AccessRequest withAuthAttributes(byte[] auth, List<RadiusAttribute> attributes) throws RadiusPacketException {
        ByteBuf header = RadiusPacket.buildHeader(this.getType(), this.getId(), auth, attributes);
        return AccessRequest.create(this.getDictionary(), header, attributes);
    }

    public static interface AccessRequestFactory {
        public AccessRequest newInstance(Dictionary var1, ByteBuf var2, List<RadiusAttribute> var3) throws RadiusPacketException;
    }
}

