/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.radius.common.packet;

import com.tplink.cdd.radius.common.RadiusPacketException;
import com.tplink.cdd.radius.common.attribute.NestedAttributeHolder;
import com.tplink.cdd.radius.common.attribute.type.RadiusAttribute;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Objects;

public interface RadiusPacket<T extends RadiusPacket<T>>
extends NestedAttributeHolder<T> {
    public static final int HEADER_LENGTH = 20;
    public static final int MAX_PACKET_LENGTH = 4096;

    public static MessageDigest getMd5Digest() {
        try {
            return MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static ByteBuf readHeader(ByteBuf data) throws RadiusPacketException {
        int length = data.readableBytes();
        if (length < 20) {
            throw new RadiusPacketException("Bad packet: parsable bytes too short (" + length + " bytes)");
        }
        if (length > 4096) {
            throw new RadiusPacketException("Bad packet: parsable bytes too long (" + length + " bytes)");
        }
        ByteBuf header = data.readSlice(20);
        short declaredLength = header.getShort(2);
        if (length != declaredLength) {
            throw new RadiusPacketException("Bad packet: packet length mismatch, parsable bytes (" + length + ")  does not match declared length (" + declaredLength + ")");
        }
        return header;
    }

    public static ByteBuf buildHeader(byte type, byte id, byte[] auth, List<RadiusAttribute> attributes) throws RadiusPacketException {
        if (auth != null && auth.length != 16) {
            throw new RadiusPacketException("Packet Authenticator must be 16 octets, actual: " + auth.length);
        }
        int attributeLen = attributes.stream().map(RadiusAttribute::getData).mapToInt(ByteBuf::readableBytes).sum();
        return Unpooled.buffer((int)20, (int)20).writeByte((int)type).writeByte((int)id).writeShort(attributeLen + 20).writeBytes(auth == null ? new byte[16] : auth);
    }

    public ByteBuf getHeader();

    public byte getType();

    public byte getId();

    public byte[] getAuthenticator();

    default public int getLength() {
        return this.getHeader().readableBytes() + this.getAttributeByteBuf().readableBytes();
    }

    default public ByteBuf toByteBuf() {
        return Unpooled.unreleasableBuffer((ByteBuf)Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{this.getHeader(), this.getAttributeByteBuf()}));
    }

    default public ByteBuffer toByteBuffer() {
        return this.toByteBuf().nioBuffer();
    }

    default public byte[] toBytes() {
        return this.toByteBuf().copy().array();
    }

    default public byte[] genHashedAuth(String sharedSecret, byte[] requestAuth) {
        Objects.requireNonNull(requestAuth, "Authenticator cannot be null");
        if (sharedSecret == null || sharedSecret.isEmpty()) {
            throw new IllegalArgumentException("Shared secret cannot be null/empty");
        }
        byte[] attributeBytes = this.getAttributeByteBuf().copy().array();
        int length = 20 + attributeBytes.length;
        MessageDigest md5 = RadiusPacket.getMd5Digest();
        md5.update(this.getType());
        md5.update(this.getId());
        md5.update((byte)(length >> 8));
        md5.update((byte)(length & 0xFF));
        md5.update(requestAuth);
        md5.update(attributeBytes);
        return md5.digest(sharedSecret.getBytes(StandardCharsets.UTF_8));
    }
}

