/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.radius.common.packet;

import java.util.HashMap;
import java.util.Map;

public class PacketType {
    public static final byte ACCESS_REQUEST = 1;
    public static final byte ACCESS_ACCEPT = 2;
    public static final byte ACCESS_REJECT = 3;
    public static final byte ACCESS_CHALLENGE = 11;
    public static final byte ACCOUNTING_REQUEST = 4;
    public static final byte ACCOUNTING_RESPONSE = 5;
    public static final byte ACCOUNTING_STATUS = 6;
    public static final byte ACCOUNTING_MESSAGE = 10;
    public static final byte PASSWORD_REQUEST = 7;
    public static final byte PASSWORD_ACCEPT = 8;
    public static final byte PASSWORD_REJECT = 9;
    public static final byte STATUS_SERVER = 12;
    public static final byte STATUS_CLIENT = 13;
    public static final byte DISCONNECT_REQUEST = 40;
    public static final byte DISCONNECT_ACK = 41;
    public static final byte DISCONNECT_NAK = 42;
    public static final byte COA_REQUEST = 43;
    public static final byte COA_ACK = 44;
    public static final byte COA_NAK = 45;
    public static final byte STATUS_REQUEST = 46;
    public static final byte STATUS_ACCEPT = 47;
    public static final byte STATUS_REJECT = 48;
    public static final byte RESERVED = -1;
    private static final Map<Byte, String> typeNames = PacketType.setupTypeNames();

    private static Map<Byte, String> setupTypeNames() {
        HashMap<Byte, String> map = new HashMap<Byte, String>();
        map.put((byte)1, "Access-Request");
        map.put((byte)2, "Access-Accept");
        map.put((byte)3, "Access-Reject");
        map.put((byte)4, "Accounting-Request");
        map.put((byte)5, "Accounting-Response");
        map.put((byte)6, "Accounting-Status");
        map.put((byte)7, "Password-Request");
        map.put((byte)8, "Password-Accept");
        map.put((byte)9, "Password-Reject");
        map.put((byte)10, "Accounting-Message");
        map.put((byte)11, "Access-Challenge");
        map.put((byte)12, "Status-Server");
        map.put((byte)13, "Status-Client");
        map.put((byte)40, "Disconnect-Request");
        map.put((byte)41, "Disconnect-ACK");
        map.put((byte)42, "Disconnect-NAK");
        map.put((byte)43, "CoA-Request");
        map.put((byte)44, "CoA-ACK");
        map.put((byte)45, "CoA-NAK");
        map.put((byte)46, "Status-Request");
        map.put((byte)47, "Status-Accept");
        map.put((byte)48, "Status-Reject");
        map.put((byte)-1, "Reserved");
        return map;
    }

    private PacketType() {
    }

    public static String getPacketTypeName(byte code) {
        return typeNames.getOrDefault(code, "Unknown (" + code + ")");
    }
}

