/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.radius.common.packet;

import com.tplink.cdd.radius.common.RadiusPacketException;
import com.tplink.cdd.radius.common.attribute.AttributeTemplate;
import com.tplink.cdd.radius.common.attribute.type.RadiusAttribute;
import com.tplink.cdd.radius.common.dictionary.Dictionary;
import com.tplink.cdd.radius.common.packet.PacketType;
import com.tplink.cdd.radius.common.packet.RadiusPacket;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class BaseRadiusPacket<T extends RadiusPacket<T>>
implements RadiusPacket<T> {
    private static final Logger logger = LogManager.getLogger();
    private static final int HEADER_LENGTH = 20;
    private static final int CHILD_VENDOR_ID = -1;
    private final Dictionary dictionary;
    private final ByteBuf header;
    private final List<RadiusAttribute> attributes;

    protected BaseRadiusPacket(Dictionary dictionary, ByteBuf header, List<RadiusAttribute> attributes) throws RadiusPacketException {
        this.dictionary = Objects.requireNonNull(dictionary, "Dictionary is null");
        this.header = Objects.requireNonNull(header);
        this.attributes = new ArrayList<RadiusAttribute>(attributes);
        if (header.readableBytes() != 20) {
            throw new IllegalArgumentException("Packet header must be length 20, actual: " + header.readableBytes());
        }
        int length = this.getLength();
        if (length > 4096) {
            throw new RadiusPacketException("Packet too long - length max 4096, actual: " + length);
        }
        short declaredLength = header.getShort(2);
        if (length != declaredLength) {
            throw new RadiusPacketException("Packet length mismatch, actual length (" + length + ")  does not match declared length (" + declaredLength + ")");
        }
    }

    @Override
    public int getChildVendorId() {
        return -1;
    }

    @Override
    public ByteBuf getHeader() {
        return Unpooled.unreleasableBuffer((ByteBuf)this.header);
    }

    @Override
    public byte getId() {
        return this.header.getByte(1);
    }

    @Override
    public byte getType() {
        return this.header.getByte(0);
    }

    @Override
    public List<RadiusAttribute> getAttributes() {
        return this.attributes;
    }

    @Override
    public byte[] getAuthenticator() {
        byte[] array = this.header.slice(4, 16).copy().array();
        return Arrays.equals(array, new byte[array.length]) ? null : array;
    }

    @Override
    public Dictionary getDictionary() {
        return this.dictionary;
    }

    @Override
    public T withAttributes(List<RadiusAttribute> attributes) throws RadiusPacketException {
        ByteBuf newHeader = RadiusPacket.buildHeader(this.getType(), this.getId(), this.getAuthenticator(), attributes);
        return this.with(newHeader, attributes);
    }

    public T withAuthAttributes(byte[] auth, List<RadiusAttribute> attributes) throws RadiusPacketException {
        ByteBuf newHeader = RadiusPacket.buildHeader(this.getType(), this.getId(), auth, attributes);
        return this.with(newHeader, attributes);
    }

    protected abstract T with(ByteBuf var1, List<RadiusAttribute> var2) throws RadiusPacketException;

    protected void verifyPacketAuth(String sharedSecret, byte[] requestAuth) throws RadiusPacketException {
        byte[] expectedAuth = this.genHashedAuth(sharedSecret, requestAuth);
        byte[] auth = this.getAuthenticator();
        if (auth == null) {
            throw new RadiusPacketException("Packet Authenticator check failed - authenticator missing");
        }
        if (auth.length != 16) {
            throw new RadiusPacketException("Packet Authenticator check failed - must be 16 octets, actual " + auth.length);
        }
        if (!Arrays.equals(expectedAuth, auth)) {
            boolean decodedAlready = this.getAttributes().stream().filter(a -> a.getAttributeTemplate().map(AttributeTemplate::encryptEnabled).orElse(false)).anyMatch(a -> !a.isEncoded());
            if (decodedAlready) {
                logger.info("Skipping Packet Authenticator check - attributes have been decrypted already");
            } else {
                throw new RadiusPacketException("Packet Authenticator check failed - bad authenticator or shared secret");
            }
        }
    }

    public String toString() {
        StringBuilder s = new StringBuilder().append(PacketType.getPacketTypeName(this.getType())).append(", ID ").append(this.getId()).append(", len ").append(this.getLength());
        for (RadiusAttribute attr : this.getAttributes()) {
            s.append("\n").append(attr.toString());
        }
        return s.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BaseRadiusPacket)) {
            return false;
        }
        BaseRadiusPacket that = (BaseRadiusPacket)o;
        return this.header.equals((Object)that.header) && this.attributes.equals(that.attributes) && this.dictionary.equals(that.dictionary);
    }

    public int hashCode() {
        return Objects.hash(this.header, this.attributes, this.dictionary);
    }
}

