/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.radius.common.enums.error;

public enum ResponseCode {
    OK(200, 0, "Success"),
    UNKNOWN_ERROR(500, -1, "Unknown error."),
    PARAM_ERROR(200, -2, "Parameter error."),
    RESOURCE_BUSY(200, -9, "Resource is busy. Please try again later."),
    ACCOUNT_INVALID_CSRF_TOKEN(200, -14, "Invalid csrfToken."),
    ERROR_UNAUTHORIZED(200, -15, "Unauthorized."),
    SERVER_INTERNAL_ERROR(500, -16, "Server error."),
    ERROR_BAD_REQUEST(200, -17, "Bad request."),
    CER_NAME_NULL(200, -30001, "Enter the Certificate name."),
    CER_TOO_LARGE(200, -30002, "The size of the certificate file has exceeded the limit. It should be less than 12MB."),
    ADD_CER_SAVE_FAIL(200, -30003, "Failed to import the certificate."),
    CER_TYPE_ERROR(200, -30004, "Certification type is unsupported."),
    CER_UN_LOAD(200, -30005, "Please upload certification first."),
    CER_NOT_EXIT(200, -30006, "Certification does not exit."),
    CER_DUPLICATE(200, -30007, "Duplicate Certification."),
    CER_PARSE_FAILED(200, -30008, "Certificate Parsing Failed."),
    SAN_VALID_FAILED(200, -30009, "Certificate SAN Valid Failed."),
    CATEGORY_NOT_FOUND(200, -10000, "Category not found."),
    CATEGORY_HAS_EXISTED(200, -10001, "Category already exists."),
    CATEGORY_STATUS_HAS_BEEN_ENABLE_OR_DISABLE(200, -10002, "Category has been disable or enable."),
    CATEGORY_SA_LIMIT_REACHED(200, -10003, "Category has reached limit."),
    CATEGORY_TYPE_MISMATCH(200, -10004, "Category type mismatch."),
    CATEGORY_NO_PERMISSION(200, -10005, "No operation permission."),
    USER_NOT_FOUND(200, -11000, "User not found."),
    USERNAME_HAS_BEEN_ADDED(200, -11001, "User already exists."),
    INVALID_USER_ROLE(200, -11002, "Invalid user role."),
    USER_HAS_BEEN_BANNED(200, -11003, "User has been banned."),
    USERNAME_OR_PASSWORD_INVALID(200, -11004, "Incorrect username or password."),
    ROLE_NOT_UNDER_ADMIN(200, -11005, "Role not under admin."),
    INVALID_PASSWORD(200, -11006, "Incorrect password."),
    ROLE_EXISTED(200, -11007, "Role name already exists."),
    USER_NOT_ACTIVATED(200, -11008, "User not activated."),
    USER_INIT_FINISHED(200, -11009, "Init already finished, please refresh to continue"),
    ERROR_PERMISSION_DENIED(200, -12000, "Permission denied."),
    PC_INCORRECT_USERNAME_OR_PASSWORD(200, -12001, "Incorrect username or password."),
    PC_ACCOUNT_IS_LOCKED(200, -12002, "Account is locked."),
    ACCOUNT_NO_PERMISSION(200, -12003, "Account has no permission."),
    USER_SECRET_LIST_NOT_FOUND(200, -13000, "UserSecretList not found."),
    WRONG_SECURITY_QUESTION(200, -13001, "Security question answer is wrong."),
    INVALID_RESEPASSWORDKEY(200, -13002, "Invalid ResePasswordKey."),
    SECURITY_QUESTION_NOT_FOUND(200, -13003, "Security question not found."),
    USER_SECRET_LIST_EXISTED(200, -13004, "UserSecretList already exists."),
    PLAN_DB_EXCEPTION(200, -15000, "Service Plan DataBase Exception"),
    PLAN_SA_DB_EXCEPTION(200, -15001, "Service Plan SA DataBase Exception"),
    PAYMENT_PARAMETER_IS_NULL(200, -15002, "Parameter cannot be null."),
    PAYMENT_PARAMETER_ERROR(200, -15003, "Parameter Error"),
    PLAN_NOT_EXIST(200, -15004, "Plan does not exist."),
    PLAN_HAS_ALREADY_EXIST(200, -15005, "Plan already exists."),
    TOO_MANY_PLANS_ON(200, -15006, "No more than 20 plans can be turned on."),
    AMOUNT_NOT_SUPPORT(200, -15007, "Invalid currency amount."),
    INVALID_CLIENT_INFO(200, -15200, "Invalid client info."),
    SP_HAS_NO_CREDENTIAL_INFO(200, -15201, "Current service provider doesn't add payment info."),
    PAYMENT_ORDER_CREATED_FAILED(200, -15202, "Failed to create the order."),
    PAYMENT_ORDER_CHARGE_FAILED(200, -15203, "Failed to charge for the order."),
    PAYMENT_ORDER_NOT_FOUND(200, -15204, "Order not found."),
    NO_PACKAGE_IS_AVAILABLE(200, -15205, "No package is available."),
    PAYMENT_ORDER_HAS_BEEN_PAID(200, -15206, "Order has been paid."),
    PAYMENT_ERROR_UNAUTHORIZED(200, -15207, "Unauthorized payment."),
    CURRENCY_NOT_ALLOWED(200, -15208, "Currency is not supported."),
    ERROR_API_RATE_LIMIT_EXCEEDED(200, -25001, "API rate exceeded the limit."),
    LOGIN_RESPONSE_NULL(200, -25002, "login response can not be null."),
    PREFIGHT_REQUEST_ERROR(200, -25003, "Prefight request error."),
    ERROR_URL_AUTHORITY(200, -25004, "User does not have the Url Authority."),
    USER_NAME_IS_NULL(200, -25005, "Username cannot be null."),
    ANNOTATION_IS_NULL(200, -25006, "The annotation of method cannot be null."),
    CSRFTOKEN_IS_NULL(200, -25007, "Unauthorized."),
    COOKIE_IS_NULL(200, -25008, "Unauthorized."),
    FILE_DOWNLOAD_FAILED(200, -25009, "File download failed."),
    WRONG_REQUEST_URL(200, -25010, "Wrong request URL."),
    FILE_SIZE_LIMIT(200, -25011, "The file size cannot exceed 100MB."),
    AUTHENTICATION_USER_HAS_ALREADY_EXIST(200, -26000, "AuthenticationUser already exists."),
    AUTHENTICATION_USER_NOT_BELONG_TO_SA(200, -26001, "DeleteAuthenticationUser does not belong to the category."),
    AUTHENTICATION_GROUP_NOT_EXIST(200, -26002, "Authentication group does not exist."),
    AUTHENTICATION_USER_NOT_IN_THE_GROUP(200, -26003, "DeleteAuthenticationUser is not in the group."),
    AUTHENTICATION_GROUP_HAS_ALREADY_EXIST(200, -26004, "AuthenticationGroup already exists."),
    AUTHNETICATION_PPSK_USER_NOT_EXIST(200, -26005, "PPSK user does not exist."),
    AUTHENTICATION_USER_NOT_FOUND(200, -26006, "Authentication User not found."),
    NO_SA_PERMISSION(200, -26007, "User doesn't have such SA permission."),
    MAC_HAS_ALREADY_EXIST(200, -26008, "The MAC address already exists."),
    NO_SUCH_SA(200, -26009, "SA permission does not exist."),
    SELF_SA_CAN_NOT_DELETE(200, -26010, "Cannot delete the user belonging SA."),
    DUPLICATE_PPSK_PASSWORD(200, -26011, "Duplicate PPSK passwords."),
    INVALID_PPSK_PASSWORD_TYPE(200, -26012, "Invalid PPSK password type."),
    INVALID_AUTHENTICATION_USER(200, -26013, "Invalid authentication user."),
    BAD_EXPIRATION_TIME(200, -26014, "Expiration time must be later than the current time."),
    INVALID_MAC(200, -26015, "Invalid MAC address."),
    NAS_PARAMETER_IS_NULL(200, -20000, "Parameter can not be null."),
    NAS_IP_FORMAT_IS_INVALID(200, -20001, "Invalid IP format."),
    NAS_MAC_FORMAT_IS_INVALID(200, -20002, "Invalid MAC format."),
    NAS_HAS_ALREADY_EXIST(200, -20003, "NAS already exists."),
    NAS_UPDATE_FAILED_NAS_NOT_EXIST(200, -20004, "NAS update failed. NAS does not exist."),
    NAS_NOT_EXIST(200, -20005, "NAS does not exist."),
    NAS_DB_EXCEPTION(200, -20006, "NAS dataBase exception."),
    NAS_BATCH_DELETE_FAILED_DB(200, -20007, "NAS batch deletion failed due to DB exception."),
    NAS_NAME_HAS_ALREADY_EXIST(200, -20008, "NAS name already exists."),
    NAS_IP_HAS_ALREADY_EXIST(200, -20009, "NAS IP already exists."),
    NAS_MAC_HAS_ALREADY_EXIST(200, -20010, "NAS MAC address already exists."),
    NAS_KEY_BOTH_NULL(200, -20011, "NAS RADIUS key and tacacs key cannot be both empty."),
    NAS_ID_NOT_UNIQUE(200, -20012, "NasId Not Unique"),
    NAS_IP_AND_EXTERNAL_IP_DUPLICATE(200, -20013, "NasIp and ExternalIp duplicate."),
    NAS_ID_ALL_NULL(200, -20014, "NasId cannot be all empty."),
    NAS_MAC_NOT_MATCH(200, -20015, "MAC dont match."),
    ALARM_RULE_DB_EXCEPTION(200, -30200, "Alarm Rule DataBase Exception"),
    ALARM_EVENT_DB_EXCEPTION(200, -30201, "Alarm Event DataBase Exception"),
    ALARM_SETTING_DB_EXCEPTION(200, -30202, "Alarm Setting DataBase Exception"),
    ALARM_PARAMETER_IS_NULL(200, -30203, "Parameter can not be null."),
    ALARM_RULE_NOT_EXIST(200, -30204, "Alarm Rule does not exist."),
    ALARM_RULE_HAS_ALREADY_EXIST(200, -30205, "Alarm Rule already exists."),
    CHAGE_ALARM_RULE_TYPE_EXIST(200, -30206, "Cannot change the Alarm Rule Type."),
    EMAIL_SETTING_ERROR(200, -30207, "Email setting error, Wrong SMTP server or port."),
    ALARM_LEVEL_ERROR(200, -30208, "Select at least one Alarm Level."),
    ALARM_PARAMETER_ERROR(200, -30209, "Parameter Error."),
    TOO_MANY_ALARM_RULE(200, -30210, "No More than 5 Alarm Rules of each Type."),
    EMAIL_SETTING_AUTH_ERROR(200, -30211, "Email Username or Password Error."),
    EMAIL_SETTING_PERMISSION_ERROR(200, -30212, "Email Permission error. Try to use Authentication or replace the Send Mailbox."),
    EMAIL_SEND_ERROR(200, -30213, "Failed to Send Email."),
    AUTH_RULE_PARAMETER_IS_NULL(200, -20100, "Parameter cannot be null."),
    AUTH_RULE_CREATE_DEFAULT_AUTH_RULE_FAILED(200, -20101, "Failed to create the default auth rule."),
    AUTH_RULE_HAS_ALREADY_EXIST(200, -20102, "Auth already exists."),
    AUTH_RULE_CAN_NOT_UPDATE_DEFAULT_PRIORITY(200, -20103, "Cannot update the default AuthRule Priority."),
    AUTH_RULE_PRIORITY_INVALID(200, -20104, "Invalid priority."),
    AUTH_RULE_DB_EXCEPTION(200, -20105, "Auth Rule DB exception."),
    AUTH_RULE_DELETE_FAILED(200, -20106, "Failed to delete the Auth Rule."),
    AUTH_RULE_NOT_EXIST(200, -20107, "Auth Rule does not exist."),
    AUTH_RULE_QUANTITY_BEYOND_LIMIT(200, -20108, "Auth Rule quantity exceeded the limit."),
    ACCOUNTING_PARAMETER_IS_NULL(200, -20200, "Parameter cannot be null."),
    ACCOUNTING_DB_EXCEPTION(200, -20201, "Accounting DB Exception."),
    ACCOUNTING_GET_USER_INFO_FAILED(200, -20202, "Failed to get the User Info."),
    ACCOUNTING_SINGLE_ACCOUNTING_NOT_EXIST(200, -20203, "Single Accounting does not exist."),
    ACCOUNTING_ENTITY_ACCOUNTING_NOT_EXIST(200, -20204, "Entity Accounting does not exist."),
    ACCOUNTING_ENUM_NOT_FOUND(200, -20205, "Accounting Enum Not Found."),
    ACCOUNTING_USER_ACCOUNTING_NOT_EXIST(200, -20206, "User Accounting does not exist."),
    ACCOUNTING_USER_ACCOUNTING_DO_IS_NULL(200, -20207, "User Accounting DO cannot be null."),
    ACCOUNTING_NAS_ACCOUNTING_NOT_EXIST(200, -20208, "NAS Accounting does not exist."),
    ACCOUNTING_NAS_ACCOUNTING_DO_IS_NULL(200, -20209, "NAS Accounting DO cannot be null."),
    ACCOUNTING_SINGLE_ACCOUNTING_DO_IS_NULL(200, -20210, "Single Accounting DO cannot be null."),
    PORTAL_PARAMETER_IS_NULL(200, -20300, "Parameter can not be null."),
    PORTAL_DB_EXCEPTION(200, -20301, "Portal DB exception."),
    PORTAL_HAS_ALREADY_EXIST(200, -20302, "Portal already exists."),
    PORTAL_NOT_EXIST(200, -20303, "Portal does not exist."),
    PORTAL_IMG_TOO_LARGE(200, -20320, "The size of the portal image should be less than 2MB."),
    PORTAL_IMG_NAME_DUPLICATE(200, -20321, "The name of the portal image already exists."),
    UNSUPPORTED_PORTAL_IMG_SUFFIX(200, -20322, "Unsupported image suffix. Only png, jpg, jpeg, bmp and gif are supported."),
    PORTAL_IMG_NOT_FOUND(200, -20323, "Portal image not found.");

    private final int httpCode;
    private int errorCode;
    private String msg;

    private ResponseCode(int httpCode, int errorCode, String msg) {
        this.httpCode = httpCode;
        this.errorCode = errorCode;
        this.msg = msg;
    }

    public int getHttpCode() {
        return this.httpCode;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public String getMsg() {
        return this.msg;
    }
}

