/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.radius.common.enums;

import com.tplink.cdd.radius.common.enums.AuthType;
import com.tplink.cdd.radius.common.enums.RadiusAuthPacketType;
import java.util.Objects;

public enum UserAuthCategory {
    USER_ACCESS_PAP(RadiusAuthPacketType.PAP, AuthType.USER_ACCESS),
    USER_ACCESS_CHAP(RadiusAuthPacketType.CHAP, AuthType.USER_ACCESS),
    USER_ACCESS_EAP(RadiusAuthPacketType.EAP, AuthType.USER_ACCESS),
    MAC_PAP(RadiusAuthPacketType.PAP, AuthType.MAC),
    MAC_EAP(RadiusAuthPacketType.EAP, AuthType.MAC),
    PPSK_BOUND_MAC_PAP(RadiusAuthPacketType.PAP, AuthType.PPSK_BOUND_MAC),
    PPSK_UNBOUND_MAC_PAP(RadiusAuthPacketType.PAP, AuthType.PPSK_UNBOUND_MAC),
    PORTAL_PAP(RadiusAuthPacketType.PAP, AuthType.PORTAL),
    PORTAL_CHAP(RadiusAuthPacketType.CHAP, AuthType.PORTAL);

    private static final String NAME_FORMAT = "(%s, %s)";
    private final RadiusAuthPacketType radiusAuthPacketType;
    private final AuthType authType;
    private final String name;

    private UserAuthCategory(RadiusAuthPacketType radiusAuthPacketType, AuthType authType) {
        this.radiusAuthPacketType = radiusAuthPacketType;
        this.authType = authType;
        this.name = String.format(NAME_FORMAT, authType.getName(), radiusAuthPacketType.getName());
    }

    public static UserAuthCategory of(RadiusAuthPacketType radiusAuthPacketType, AuthType authType) {
        for (UserAuthCategory userAuthCategory : UserAuthCategory.values()) {
            if (!Objects.equals((Object)userAuthCategory.getRadiusAuthPacketType(), (Object)radiusAuthPacketType) || !Objects.equals((Object)userAuthCategory.getAuthType(), (Object)authType)) continue;
            return userAuthCategory;
        }
        return null;
    }

    public RadiusAuthPacketType getRadiusAuthPacketType() {
        return this.radiusAuthPacketType;
    }

    public AuthType getAuthType() {
        return this.authType;
    }

    public String getName() {
        return this.name;
    }
}

