/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.radius.common.enums;

import java.util.Objects;

public enum RadiusAvp {
    USER_NAME("User-Name", 1),
    USER_PASSWORD("User-Password", 2),
    CHAP_PASSWORD("Chap-Password", 3),
    NAS_IP_ADDRESS("NAS-IP-Address", 4),
    SERVICE_TYPE("Service-Type", 6),
    FRAMED_IP_ADDRESS("Framed-IP-Address", 8),
    VENDOR_SPECIFIC("Vendor-Specific", 26),
    SESSION_TIMEOUT("Session-Timeout", 27),
    CALLED_STATION_ID("Called-Station-Id", 30),
    CALLING_STATION_ID("Calling-Station-Id", 31),
    NAS_IDENTIFIER("NAS-Identifier", 32),
    ACCT_SESSION_ID("Acct-Session-Id", 44),
    CHAP_CHALLENGE("CHAP-Challenge", 60),
    TUNNEL_TYPE("Tunnel-Type", 64),
    TUNNEL_MEDIUM_TYPE("Tunnel-Medium-Type", 65),
    TUNNEL_PASSWORD("Tunnel-Password", 69),
    EAP_MESSAGE("EAP-Message", 79),
    MESSAGE_AUTHENTICATOR("Message-Authenticator", 80),
    ERROR_CAUSE("Error-Cause", 101),
    TUNNEL_PRIVATE_GROUP_ID("Tunnel-Private-Group-Id", 81);

    private final String name;
    private final int index;

    private RadiusAvp(String name, int index) {
        this.name = name;
        this.index = index;
    }

    public static RadiusAvp fromIndex(int index) {
        for (RadiusAvp radiusAvp : RadiusAvp.values()) {
            if (!Objects.equals(radiusAvp.getIndex(), index)) continue;
            return radiusAvp;
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public int getIndex() {
        return this.index;
    }
}

