/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.radius.common.enums;

import com.tplink.cdd.radius.common.packet.request.AccessRequest;
import com.tplink.cdd.radius.common.packet.request.AccessRequestChap;
import com.tplink.cdd.radius.common.packet.request.AccessRequestEap;
import com.tplink.cdd.radius.common.packet.request.AccessRequestPap;
import java.util.Objects;

public enum RadiusAuthPacketType {
    PAP(0, "pap", 2, AccessRequestPap.class),
    CHAP(1, "chap", 3, AccessRequestChap.class),
    EAP(2, "eap", 79, AccessRequestEap.class);

    private final Integer index;
    private final String name;
    private final Integer avpId;
    private final Class<?> accessRequestClazz;

    private RadiusAuthPacketType(Integer index, String name, Integer avpId, Class<? extends AccessRequest> accessRequestClazz) {
        this.index = index;
        this.name = name;
        this.avpId = avpId;
        this.accessRequestClazz = accessRequestClazz;
    }

    public static RadiusAuthPacketType fromAccessRequest(AccessRequest accessRequest) {
        for (RadiusAuthPacketType type : RadiusAuthPacketType.values()) {
            if (!type.getAccessRequestClazz().isInstance(accessRequest)) continue;
            return type;
        }
        return null;
    }

    public static RadiusAuthPacketType fromIndex(Integer index) {
        for (RadiusAuthPacketType type : RadiusAuthPacketType.values()) {
            if (!Objects.equals(type.getIndex(), index)) continue;
            return type;
        }
        return null;
    }

    public Integer getIndex() {
        return this.index;
    }

    public String getName() {
        return this.name;
    }

    public Integer getAvpId() {
        return this.avpId;
    }

    public Class<?> getAccessRequestClazz() {
        return this.accessRequestClazz;
    }
}

