/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.radius.common.enums;

import com.tplink.cdd.radius.common.eap.enums.DataType;
import com.tplink.cdd.radius.common.enums.RadiusAuthPacketType;
import com.tplink.cdd.radius.common.packet.request.AccessRequest;
import com.tplink.cdd.radius.common.packet.request.AccessRequestEap;
import java.util.Objects;

public enum AuthProtocol {
    PAP(0, "pap", RadiusAuthPacketType.PAP),
    CHAP(1, "chap", RadiusAuthPacketType.CHAP),
    IDENTITY(2, "identity", RadiusAuthPacketType.EAP),
    NAK(3, "nak", RadiusAuthPacketType.EAP),
    EAP_MD5(4, "eap-md5", RadiusAuthPacketType.EAP),
    EAP_TLS(5, "eap-tls", RadiusAuthPacketType.EAP),
    EAP_TTLS(6, "eap-ttls", RadiusAuthPacketType.EAP),
    PEAP(7, "peap", RadiusAuthPacketType.EAP),
    MS_CHAP_V2(8, "ms-chap-v2", RadiusAuthPacketType.EAP),
    GTC(9, "gtc", RadiusAuthPacketType.EAP),
    TACACS_ASCII(11, "tacacs-ascii", null);

    private final Integer index;
    private final String name;
    private final RadiusAuthPacketType radiusAuthPacketType;

    private AuthProtocol(Integer index, String name, RadiusAuthPacketType radiusAuthPacketType) {
        this.index = index;
        this.name = name;
        this.radiusAuthPacketType = radiusAuthPacketType;
    }

    public static AuthProtocol fromIndex(Integer index) {
        for (AuthProtocol protocol : AuthProtocol.values()) {
            if (!Objects.equals(protocol.getIndex(), index)) continue;
            return protocol;
        }
        return null;
    }

    public static AuthProtocol fromPacketType(RadiusAuthPacketType packetType, AccessRequest accessRequest) {
        for (AuthProtocol protocol : AuthProtocol.values()) {
            if (!Objects.equals((Object)protocol.getRadiusAuthPacketType(), (Object)packetType)) continue;
            if (Objects.equals((Object)packetType, (Object)RadiusAuthPacketType.EAP)) {
                AccessRequestEap accessRequestEap = (AccessRequestEap)accessRequest;
                DataType dataType = accessRequestEap.getEapResponse().getDataType();
                return dataType.getAuthProtocol();
            }
            return protocol;
        }
        return null;
    }

    public static boolean isEapSpecAuthPacket(AuthProtocol authProtocol) {
        return !Objects.equals((Object)PAP, (Object)authProtocol) && !Objects.equals((Object)CHAP, (Object)authProtocol) && !Objects.equals((Object)IDENTITY, (Object)authProtocol) && !Objects.equals((Object)NAK, (Object)authProtocol);
    }

    public Integer getIndex() {
        return this.index;
    }

    public String getName() {
        return this.name;
    }

    public RadiusAuthPacketType getRadiusAuthPacketType() {
        return this.radiusAuthPacketType;
    }
}

