/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.radius.common.eap.packet.data;

import com.tplink.cdd.radius.common.eap.EapPacketException;
import com.tplink.cdd.radius.common.eap.enums.DataType;
import com.tplink.cdd.radius.common.eap.packet.EapResponse;
import com.tplink.cdd.radius.common.tls.CipherSuite.TlsCipher;
import com.tplink.cdd.radius.common.tls.TlsPacket;
import com.tplink.cdd.radius.common.tls.TlsPacketException;
import com.tplink.cdd.radius.common.tls.recordlayer.RecordLayer;
import com.tplink.cdd.radius.common.tls.recordlayer.handshake.ClientHello;
import com.tplink.cdd.radius.common.tls.recordlayer.handshake.ClientKeyExchange;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.List;
import java.util.Objects;

public class EapTlsPacket {
    private final byte flags;
    private int length;
    private TlsPacket tlsPacket;
    private ByteBuf splitFragment;

    public static EapTlsPacket fromEapResponse(EapResponse eapResponse, TlsCipher tlsCipher) throws EapPacketException {
        DataType dataType = eapResponse.getDataType();
        ByteBuf dataValue = eapResponse.getDataValue();
        byte flags = dataValue.readByte();
        int declaredLength = 0;
        if (EapTlsPacket.lengthIncluded(flags)) {
            declaredLength = dataValue.readInt();
        }
        try {
            switch (dataType) {
                case EAP_TLS: {
                    if (EapTlsPacket.isSplitFragment(flags, dataValue)) {
                        return new EapTlsPacket(flags, dataValue);
                    }
                }
                case EAP_TTLS: 
                case PEAP: {
                    TlsPacket tlsPacket = TlsPacket.fromByteBuf(dataValue, tlsCipher);
                    return new EapTlsPacket(flags, declaredLength, tlsPacket);
                }
            }
            throw new EapPacketException("Unsupported Data Type [ " + (Object)((Object)dataType) + " ]");
        }
        catch (TlsPacketException e) {
            throw new EapPacketException("Failed to parse EAP-TLS Packet, error msg : " + e.getMessage(), e);
        }
    }

    public static EapTlsPacket assembleSplitFragment(List<ByteBuf> splitFragmentList) throws EapPacketException {
        TlsPacket tlsPacket;
        ByteBuf byteBuf = Unpooled.buffer();
        for (ByteBuf splitFragment : splitFragmentList) {
            byteBuf.writeBytes(splitFragment);
        }
        try {
            tlsPacket = TlsPacket.fromByteBuf(byteBuf, null);
        }
        catch (TlsPacketException e) {
            throw new EapPacketException("Failed to parse EAP-TLS Packet, error msg = " + e.getMessage(), e);
        }
        return new EapTlsPacket(0, 0, tlsPacket);
    }

    private static boolean lengthIncluded(byte flags) {
        return flags == -64 || flags == -128;
    }

    private static boolean isSplitFragment(byte flags, ByteBuf byteBuf) {
        return flags == -64 || flags == 64 || flags == 0 && byteBuf.isReadable();
    }

    public EapTlsPacket(byte flags, List<RecordLayer> recordLayerList) {
        this(flags, new TlsPacket(recordLayerList));
    }

    public EapTlsPacket(byte flags, ByteBuf splitFragment) {
        this.flags = flags;
        this.splitFragment = splitFragment;
    }

    public EapTlsPacket(byte flags, TlsPacket tlsPacket) {
        this(flags, tlsPacket.getSize(), tlsPacket);
    }

    private EapTlsPacket(byte flags, int length, TlsPacket tlsPacket) {
        this.flags = flags;
        this.length = length;
        this.tlsPacket = tlsPacket;
    }

    public ByteBuf toByteBuf() {
        ByteBuf byteBuf = Unpooled.buffer().writeByte((int)this.flags);
        if (Objects.equals(this.flags, (byte)-128) || Objects.equals(this.flags, (byte)-64)) {
            byteBuf.writeInt(this.length);
        }
        return byteBuf.writeBytes(this.tlsPacket.toByteBuf());
    }

    public byte getFlags() {
        return this.flags;
    }

    public int getLength() {
        return this.length;
    }

    public TlsPacket getTlsPacket() {
        return this.tlsPacket;
    }

    public ByteBuf getSplitFragment() {
        return this.splitFragment;
    }

    public boolean isAlert() {
        return !Objects.isNull(this.tlsPacket) && this.tlsPacket.containsAlert();
    }

    public boolean isClientHello() {
        return !Objects.isNull(this.tlsPacket) && this.tlsPacket.containsHandshakeProtocol(ClientHello.class);
    }

    public boolean isClientKeyFullPacket() {
        return !Objects.isNull(this.tlsPacket) && this.tlsPacket.containsHandshakeProtocol(ClientKeyExchange.class);
    }

    public boolean isClientKeyFirstFragment() {
        return Objects.equals(this.flags, (byte)-64);
    }

    public boolean isClientKeyMiddleFragment() {
        return Objects.equals(this.flags, (byte)64);
    }

    public boolean isClientKeyLastFragment() {
        return Objects.equals(this.flags, (byte)0) && !Objects.isNull(this.splitFragment);
    }

    public boolean isNoFlagsAndNoSplitFragment() {
        return Objects.equals(this.flags, (byte)0) && Objects.isNull(this.splitFragment);
    }

    public boolean isApplicationData() {
        return !Objects.isNull(this.tlsPacket) && this.tlsPacket.containsApplicationData();
    }
}

