/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.radius.common.eap.packet;

import com.tplink.cdd.radius.common.attribute.type.RadiusAttribute;
import com.tplink.cdd.radius.common.dictionary.Dictionary;
import com.tplink.cdd.radius.common.eap.EapPacketException;
import com.tplink.cdd.radius.common.enums.RadiusAvp;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public interface EapPacket {
    public static final int HEADER_SIZE = 4;
    public static final int CODE_SIZE = 1;
    public static final int IDENTIFIER_SIZE = 1;
    public static final int DATA_TYPE_SIZE = 1;

    public static ByteBuf readHeader(ByteBuf eapPacketByteBuf) throws EapPacketException {
        int length = eapPacketByteBuf.readableBytes();
        if (length < 4) {
            throw new EapPacketException("Bad packet: parsable bytes too short (" + length + " bytes)");
        }
        ByteBuf header = eapPacketByteBuf.readBytes(4);
        short declaredLength = header.getShort(2);
        if (length != declaredLength) {
            throw new EapPacketException("Bad packet: packet length mismatch, parsable bytes (" + length + ")  does not match declared length (" + declaredLength + ")");
        }
        return header;
    }

    public static ByteBuf buildHeader(byte code, byte id, ByteBuf data) {
        int dataLen = data.readableBytes();
        return Unpooled.buffer().writeByte((int)code).writeByte((int)id).writeShort(4 + dataLen);
    }

    public ByteBuf getHeader();

    public byte getCode();

    public byte getId();

    public ByteBuf getData();

    default public ByteBuf toByteBuf() {
        return Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{this.getHeader(), this.getData()});
    }

    default public int getLength() {
        int headerSize = this.getHeader().readableBytes();
        ByteBuf data = this.getData();
        if (Objects.isNull(data)) {
            return headerSize;
        }
        return headerSize + data.readableBytes();
    }

    default public List<RadiusAttribute> toRadiusAttribute(Dictionary dictionary) {
        CompositeByteBuf byteBufOfHeaderAndData = Unpooled.compositeBuffer();
        byteBufOfHeaderAndData.addComponent(true, this.getHeader());
        ByteBuf data = this.getData();
        if (Objects.nonNull(data)) {
            byteBufOfHeaderAndData.addComponent(true, data);
        }
        ArrayList<RadiusAttribute> radiusAttributeList = new ArrayList<RadiusAttribute>();
        while (byteBufOfHeaderAndData.readableBytes() > 0) {
            ByteBuf fragmentByteBuf = Unpooled.buffer();
            byteBufOfHeaderAndData.readBytes(fragmentByteBuf, Math.min(byteBufOfHeaderAndData.readableBytes(), 253));
            ByteBuf eapMessageByteBuf = Unpooled.buffer().writeByte((int)((byte)RadiusAvp.EAP_MESSAGE.getIndex())).writeByte(fragmentByteBuf.readableBytes() + 1 + 1).writeBytes(fragmentByteBuf);
            RadiusAttribute eapMessageRadiusAttribute = dictionary.createAttribute(-1, RadiusAvp.EAP_MESSAGE.getIndex(), eapMessageByteBuf);
            radiusAttributeList.add(eapMessageRadiusAttribute);
        }
        return radiusAttributeList;
    }
}

