/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.radius.common.eap.packet;

import com.tplink.cdd.radius.common.attribute.type.RadiusAttribute;
import com.tplink.cdd.radius.common.eap.EapPacketException;
import com.tplink.cdd.radius.common.eap.enums.DataType;
import com.tplink.cdd.radius.common.eap.packet.EapData;
import com.tplink.cdd.radius.common.eap.packet.EapFailure;
import com.tplink.cdd.radius.common.eap.packet.EapPacket;
import com.tplink.cdd.radius.common.eap.packet.EapRequest;
import com.tplink.cdd.radius.common.eap.packet.EapResponse;
import com.tplink.cdd.radius.common.eap.packet.EapSuccess;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseEapPacket
implements EapPacket {
    private static final Logger log = LoggerFactory.getLogger(BaseEapPacket.class);
    private final ByteBuf header;
    private final ByteBuf data;

    protected BaseEapPacket(ByteBuf header, ByteBuf data) throws EapPacketException {
        short declaredLength;
        if (header.readableBytes() != 4) {
            throw new IllegalArgumentException("Packet header must be length 4, actual: " + header.readableBytes());
        }
        byte code = header.getByte(0);
        if ((code == 3 || code == 4) && Objects.nonNull(data)) {
            throw new IllegalArgumentException("Packet [ SUCCESS | FAILURE ] can not have data");
        }
        this.header = Objects.requireNonNull(header);
        this.data = data;
        int length = this.getLength();
        if (length != (declaredLength = header.getShort(2))) {
            throw new EapPacketException("Packet length mismatch, actual length (" + length + ")  does not match declared length (" + declaredLength + ")");
        }
    }

    public static EapPacket fromEapMessageList(List<RadiusAttribute> radiusAttributeList) throws EapPacketException {
        ByteBuf eapMessageByteBuf = Unpooled.buffer();
        if (BaseEapPacket.isFullEapMessage(radiusAttributeList)) {
            ByteBuf attributeByteBuf = radiusAttributeList.iterator().next().toByteBuf().copy();
            attributeByteBuf.readShort();
            eapMessageByteBuf.writeBytes(attributeByteBuf);
        } else {
            radiusAttributeList.forEach(radiusAttribute -> {
                ByteBuf attributeByteBuf = radiusAttribute.toByteBuf().copy();
                attributeByteBuf.readShort();
                eapMessageByteBuf.writeBytes(attributeByteBuf);
            });
        }
        return BaseEapPacket.fromByteBuf(eapMessageByteBuf);
    }

    public static EapPacket fromByteBuf(ByteBuf eapPacket) throws EapPacketException {
        int packetLength = eapPacket.readableBytes();
        ByteBuf header = EapPacket.readHeader(eapPacket);
        ByteBuf data = eapPacket.readBytes(packetLength - 4);
        return BaseEapPacket.create(header, data);
    }

    public static EapPacket create(ByteBuf header, ByteBuf data) throws EapPacketException {
        return BaseEapPacket.lookupEapCode(header).newInstance(header, data);
    }

    private static EapPacketFactory lookupEapCode(ByteBuf header) throws EapPacketException {
        byte code = header.getByte(0);
        switch (code) {
            case 1: {
                return EapRequest::new;
            }
            case 2: {
                return EapResponse::new;
            }
            case 3: {
                return EapSuccess::new;
            }
            case 4: {
                return EapFailure::new;
            }
        }
        throw new EapPacketException("Not support the EAP packet type = " + code);
    }

    private static boolean isFullEapMessage(List<RadiusAttribute> radiusAttributeList) {
        return Objects.equals(radiusAttributeList.size(), 1);
    }

    protected EapData parseData() {
        byte type = this.data.getByte(0);
        ByteBuf value = this.data.slice(1, this.data.readableBytes() - 1).copy();
        return EapData.builder().type(DataType.fromIndex(type)).value(value).build();
    }

    @Override
    public ByteBuf getHeader() {
        return this.header;
    }

    @Override
    public byte getCode() {
        return this.header.getByte(0);
    }

    @Override
    public byte getId() {
        return this.header.getByte(1);
    }

    @Override
    public ByteBuf getData() {
        return this.data;
    }

    public static interface EapPacketFactory {
        public EapPacket newInstance(ByteBuf var1, ByteBuf var2) throws EapPacketException;
    }
}

