/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.radius.common.eap.enums;

import com.tplink.cdd.radius.common.enums.AuthProtocol;
import java.util.Objects;

public enum DataType {
    IDENTITY(1, "Identity", AuthProtocol.IDENTITY),
    NAK(3, "Nak", AuthProtocol.NAK),
    MD5_CHALLENGE(4, "MD5-Challenge", AuthProtocol.EAP_MD5),
    GTC(6, "GTC", AuthProtocol.GTC),
    EAP_TLS(13, "EAP-TLS", AuthProtocol.EAP_TLS),
    EAP_TTLS(21, "EAP-TTLS", AuthProtocol.EAP_TTLS),
    PEAP(25, "PEAP", AuthProtocol.PEAP),
    EAP_EXTENSIONS(33, "EAP Extensions", null),
    MS_CHAP_V2(26, "MS-CHAP-V2", AuthProtocol.MS_CHAP_V2);

    private final byte index;
    private final String name;
    private final AuthProtocol authProtocol;

    private DataType(byte index, String name, AuthProtocol authProtocol) {
        this.index = index;
        this.name = name;
        this.authProtocol = authProtocol;
    }

    public static DataType fromIndex(byte index) {
        for (DataType dataType : DataType.values()) {
            if (!Objects.equals(dataType.getIndex(), index)) continue;
            return dataType;
        }
        return null;
    }

    public byte getIndex() {
        return this.index;
    }

    public String getName() {
        return this.name;
    }

    public AuthProtocol getAuthProtocol() {
        return this.authProtocol;
    }
}

