/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.radius.common.dictionary.parser.resolver;

import com.tplink.cdd.radius.common.dictionary.parser.resolver.ResourceResolver;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;

public class FileResourceResolver
implements ResourceResolver {
    public static final ResourceResolver INSTANCE = new FileResourceResolver();

    private FileResourceResolver() {
    }

    @Override
    public String resolve(String currentResource, String nextResource) {
        Path path = Paths.get(currentResource, new String[0]).getParent().resolve(nextResource);
        return Files.exists(path, new LinkOption[0]) ? path.toString() : "";
    }

    @Override
    public InputStream openStream(String resource) throws IOException {
        Path path = Paths.get(resource, new String[0]);
        if (Files.exists(path, new LinkOption[0])) {
            return Files.newInputStream(path, new OpenOption[0]);
        }
        throw new IOException("Could not open stream, file not found: " + resource);
    }
}

