/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.radius.common.dictionary.parser.resolver;

import com.tplink.cdd.radius.common.dictionary.parser.resolver.ResourceResolver;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;

public class ClasspathResourceResolver
implements ResourceResolver {
    public static final ResourceResolver INSTANCE = new ClasspathResourceResolver();

    private ClasspathResourceResolver() {
    }

    @Override
    public String resolve(String currentResource, String nextResource) {
        Path parent = Paths.get(currentResource, new String[0]).getParent();
        String path = parent != null ? parent.resolve(nextResource).toString() : Paths.get(nextResource, new String[0]).toString();
        return this.getClass().getClassLoader().getResource(path) != null ? path : "";
    }

    @Override
    public InputStream openStream(String resource) throws IOException {
        InputStream stream = this.getClass().getClassLoader().getResourceAsStream(resource);
        if (stream != null) {
            return stream;
        }
        throw new IOException("Could not open stream, classpath resource not found: " + resource);
    }
}

