/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.radius.common.dictionary.parser;

import com.tplink.cdd.radius.common.attribute.AttributeTemplate;
import com.tplink.cdd.radius.common.dictionary.MemoryDictionary;
import com.tplink.cdd.radius.common.dictionary.Vendor;
import com.tplink.cdd.radius.common.dictionary.WritableDictionary;
import com.tplink.cdd.radius.common.dictionary.parser.resolver.ResourceResolver;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ResourceParser {
    private static final Logger logger = LogManager.getLogger();
    private final WritableDictionary dictionary;
    private final ResourceResolver resourceResolver;
    private final List<Consumer<WritableDictionary>> deferred = new LinkedList<Consumer<WritableDictionary>>();
    private int currentVendor = -1;

    public ResourceParser(ResourceResolver resourceResolver) {
        this(new MemoryDictionary(), resourceResolver);
    }

    public ResourceParser(WritableDictionary dictionary, ResourceResolver resourceResolver) {
        this.dictionary = dictionary;
        this.resourceResolver = resourceResolver;
    }

    public WritableDictionary parseDictionary(String resource) throws IOException {
        try (InputStream inputStream = this.resourceResolver.openStream(resource);
             BufferedReader in = new BufferedReader(new InputStreamReader(inputStream));){
            String line;
            int lineNum = -1;
            while ((line = in.readLine()) != null) {
                this.parseLine(line, ++lineNum, resource);
            }
            this.currentVendor = -1;
            try {
                for (Consumer<WritableDictionary> d : this.deferred) {
                    d.accept(this.dictionary);
                }
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                throw e;
            }
        }
        return this.dictionary;
    }

    private void parseLine(String rawLine, int lineNum, String resource) throws IOException {
        String line;
        int commentIndex = rawLine.indexOf(35);
        String string = line = commentIndex == -1 ? rawLine.trim() : rawLine.substring(0, commentIndex).trim();
        if (line.isEmpty()) {
            return;
        }
        String[] tokens = line.split("\\s+");
        if (tokens.length != 0) {
            this.parseTokens(tokens, lineNum, resource);
        }
    }

    private void parseTokens(String[] tokens, int lineNum, String resource) throws IOException {
        switch (tokens[0].toUpperCase()) {
            case "END-VENDOR": {
                this.parseEndVendor(tokens, lineNum);
                break;
            }
            case "BEGIN-VENDOR": {
                this.parseBeginVendor(tokens, lineNum);
                break;
            }
            case "ATTRIBUTE": 
            case "VENDORATTR": {
                this.parseAttribute(tokens, lineNum);
                break;
            }
            case "VALUE": {
                this.deferred.add(this.parseValue(tokens, lineNum));
                break;
            }
            case "$INCLUDE": {
                this.includeDictionaryFile(tokens, lineNum, resource);
                break;
            }
            case "VENDOR": {
                this.parseVendor(tokens, lineNum);
                break;
            }
            case "BEGIN-TLV": {
                logger.warn("'BEGIN-TLV' not supported - ignoring");
                break;
            }
            case "END-TLV": {
                logger.warn("'END-TLV' not supported - ignoring");
                break;
            }
            case "PROTOCOL": {
                logger.warn("'PROTOCOL' not supported - ignoring");
                break;
            }
            case "BEGIN-PROTOCOL": {
                logger.warn("'BEGIN-PROTOCOL' not supported - ignoring");
                break;
            }
            case "END-PROTOCOL": {
                logger.warn("'END-PROTOCOL' not supported - ignoring");
                break;
            }
            case "MEMBER": {
                logger.warn("'MEMBER' not supported - ignoring");
                break;
            }
            default: {
                throw new IOException("Could not decode tokens on line " + lineNum + ": " + Arrays.toString(tokens));
            }
        }
    }

    private void parseBeginVendor(String[] tok, int lineNum) throws IOException {
        if (tok.length < 2 || tok.length > 3) {
            throw new IOException("BEGIN-VENDOR parse error on line " + lineNum + ", " + Arrays.toString(tok));
        }
        this.currentVendor = this.dictionary.getVendor(tok[1]).map(Vendor::getId).orElse(-1);
    }

    private void parseEndVendor(String[] tok, int lineNum) throws IOException {
        if (tok.length != 2) {
            throw new IOException("End-Vendor parse error on line " + lineNum + ", " + Arrays.toString(tok));
        }
        int vendorId = this.dictionary.getVendor(tok[1]).map(Vendor::getId).orElse(-1);
        if (this.currentVendor != vendorId) {
            throw new IOException("END-VENDOR parse error on line " + lineNum + ", " + Arrays.toString(tok) + " (no corresponding Begin-Vendor found)");
        }
        this.currentVendor = -1;
    }

    private void parseAttribute(String[] tok, int lineNum) throws IOException {
        int offset;
        int n = offset = tok[0].equals("VENDORATTR") ? 1 : 0;
        if (tok.length < 4 + offset || tok.length > 5 + offset) {
            throw new IOException(tok[0] + " parse error on line " + lineNum + ", " + Arrays.toString(tok));
        }
        int vendorId = offset == 1 ? Integer.parseInt(tok[1]) : this.currentVendor;
        String name = tok[1 + offset];
        int type = this.validateType(Integer.decode(tok[2 + offset]), vendorId);
        String typeStr = tok[3 + offset];
        if (tok.length == 4 + offset) {
            this.dictionary.addAttributeTemplate(new AttributeTemplate(vendorId, type, name, typeStr, 0, false));
            return;
        }
        String[] flags = tok[4 + offset].split(",");
        this.dictionary.addAttributeTemplate(new AttributeTemplate(vendorId, type, name, typeStr, this.encryptFlag(flags), this.tagFlag(flags)));
    }

    private Consumer<WritableDictionary> parseValue(String[] tok, int lineNum) throws IOException {
        if (tok.length != 4) {
            throw new IOException("VALUE parse error on line " + lineNum + ": " + Arrays.toString(tok));
        }
        String attributeName = tok[1];
        String enumName = tok[2];
        String valStr = tok[3];
        return d -> d.getAttributeTemplate(attributeName).orElseThrow(() -> new RuntimeException(new IOException("Unknown attribute type while parsing VALUE: " + attributeName + ", line: " + lineNum))).addEnumerationValue(Integer.decode(valStr), Long.decode(valStr), enumName);
    }

    private void parseVendor(String[] tok, int lineNum) throws IOException {
        int[] nArray;
        if (tok.length < 3 || tok.length > 4) {
            throw new IOException("VENDOR parse error on line " + lineNum + ": " + Arrays.toString(tok));
        }
        if (tok.length == 4) {
            nArray = this.formatFlag(tok[3]);
        } else {
            int[] nArray2 = new int[2];
            nArray2[0] = 1;
            nArray = nArray2;
            nArray2[1] = 1;
        }
        int[] format = nArray;
        try {
            int id = Integer.parseInt(tok[1]);
            String name = tok[2];
            this.dictionary.addVendor(new Vendor(id, name, format[0], format[1]));
        }
        catch (NumberFormatException e) {
            try {
                String name = tok[1];
                int id = Integer.parseInt(tok[2]);
                this.dictionary.addVendor(new Vendor(id, name, format[0], format[1]));
            }
            catch (NumberFormatException e1) {
                throw new IOException("Vendor parse error on line " + lineNum + ": " + Arrays.toString(tok));
            }
        }
    }

    private void includeDictionaryFile(String[] tok, int lineNum, String currentResource) throws IOException {
        if (tok.length != 2) {
            throw new IOException("Dictionary include parse error on line " + lineNum + ": " + Arrays.toString(tok));
        }
        String includeFile = tok[1];
        String nextResource = this.resourceResolver.resolve(currentResource, includeFile);
        if (nextResource.isEmpty()) {
            throw new IOException("Included file '" + includeFile + "' was not found, line " + lineNum + ", " + currentResource);
        }
        new ResourceParser(this.dictionary, this.resourceResolver).parseDictionary(nextResource);
    }

    private int validateType(int type, int vendorId) {
        int max = this.dictionary.getVendor(vendorId).map(Vendor::getTypeSize).map(t -> (int)Math.pow(2.0, 8.0 * (double)t.intValue()) - 1).orElse(255);
        if (type < 0 || type > max) {
            throw new IllegalArgumentException("Attribute type code out of bounds: " + type + ", max " + max);
        }
        return type;
    }

    private int[] formatFlag(String flag) {
        String[] values;
        if (flag.startsWith("format=") && (values = flag.substring(7).split(",")).length == 2) {
            try {
                return new int[]{Integer.parseInt(values[0]), Integer.parseInt(values[1])};
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        logger.warn("Ignoring vendor flag - invalid format: {}", (Object)flag);
        return new int[]{1, 1};
    }

    private byte encryptFlag(String[] flags) {
        for (String flag : flags) {
            if (flag.length() != 9 || !flag.startsWith("encrypt=")) continue;
            return Byte.parseByte(flag.substring(8, 9));
        }
        return 0;
    }

    private boolean tagFlag(String[] flags) {
        for (String flag : flags) {
            if (!flag.equals("has_tag")) continue;
            return true;
        }
        return false;
    }
}

