/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.radius.common.dictionary;

import java.nio.ByteBuffer;
import java.util.Objects;

public class Vendor {
    private final int id;
    private final String name;
    private final int typeSize;
    private final int lengthSize;

    public Vendor(int id, String name, int typeSize, int lengthSize) {
        this.id = id;
        this.name = Objects.requireNonNull(name);
        this.typeSize = typeSize;
        this.lengthSize = lengthSize;
        if (id < 0) {
            throw new IllegalArgumentException("Vendor ID must be positive: " + id + " (" + name + ")");
        }
        if (name.isEmpty()) {
            throw new IllegalArgumentException("Vendor name empty: " + name + " (vendorId" + id + ")");
        }
        if (typeSize != 1 && typeSize != 2 && typeSize != 4) {
            throw new IllegalArgumentException("Vendor typeSize must be 1, 2, or 4");
        }
        if (lengthSize != 0 && lengthSize != 1 && lengthSize != 2) {
            throw new IllegalArgumentException("Vendor lengthSize must be 0, 1, or 2");
        }
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public int getTypeSize() {
        return this.typeSize;
    }

    public int getLengthSize() {
        return this.lengthSize;
    }

    public int getHeaderSize() {
        return this.typeSize + this.lengthSize;
    }

    public byte[] toTypeBytes(int type) {
        switch (this.typeSize) {
            case 2: {
                return ByteBuffer.allocate(2).putShort((short)type).array();
            }
            case 4: {
                return ByteBuffer.allocate(4).putInt(type).array();
            }
        }
        return new byte[]{(byte)type};
    }

    public byte[] toLengthBytes(int len) {
        switch (this.lengthSize) {
            case 0: {
                return new byte[0];
            }
            case 2: {
                return ByteBuffer.allocate(2).putShort((short)len).array();
            }
        }
        return new byte[]{(byte)len};
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Vendor)) {
            return false;
        }
        Vendor vendor = (Vendor)o;
        return this.id == vendor.id && this.typeSize == vendor.typeSize && this.lengthSize == vendor.lengthSize && this.name.equals(vendor.name);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.typeSize, this.lengthSize);
    }

    public String toString() {
        return "Vendor{id=" + this.id + ", name='" + this.name + '\'' + ", typeSize=" + this.typeSize + ", lengthSize=" + this.lengthSize + '}';
    }
}

