/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.radius.common.dictionary;

import com.tplink.cdd.radius.common.attribute.AttributeTemplate;
import com.tplink.cdd.radius.common.dictionary.Vendor;
import com.tplink.cdd.radius.common.dictionary.WritableDictionary;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MemoryDictionary
implements WritableDictionary {
    private static final Logger logger = LogManager.getLogger();
    private final Map<Integer, Vendor> vendorsByCode = new HashMap<Integer, Vendor>();
    private final Map<Integer, Map<Integer, AttributeTemplate>> attributesByCode = new HashMap<Integer, Map<Integer, AttributeTemplate>>();
    private final Map<String, AttributeTemplate> attributesByName = new HashMap<String, AttributeTemplate>();

    @Override
    public Optional<AttributeTemplate> getAttributeTemplate(int vendorCode, int type) {
        Map<Integer, AttributeTemplate> vendorAttributes = this.attributesByCode.get(vendorCode);
        return Optional.ofNullable(vendorAttributes).map(va -> (AttributeTemplate)va.get(type));
    }

    @Override
    public Optional<AttributeTemplate> getAttributeTemplate(String name) {
        return Optional.ofNullable(this.attributesByName.get(name));
    }

    @Override
    public Optional<Vendor> getVendor(String vendorName) {
        return this.vendorsByCode.values().stream().filter(e -> e.getName().equals(vendorName)).findFirst();
    }

    @Override
    public Optional<Vendor> getVendor(int vendorId) {
        return Optional.ofNullable(this.vendorsByCode.get(vendorId));
    }

    @Override
    public MemoryDictionary addVendor(Vendor vendor) {
        Optional<Vendor> existing = this.getVendor(vendor.getId());
        if (existing.isPresent()) {
            if (existing.get().equals(vendor)) {
                logger.info("Ignoring duplicate vendor definition: {}", (Object)vendor);
                return this;
            }
            throw new IllegalArgumentException("Duplicate vendor code: " + vendor.getId() + " (adding " + vendor + ", but already set to " + existing.get() + ")");
        }
        this.vendorsByCode.put(vendor.getId(), vendor);
        return this;
    }

    @Override
    public MemoryDictionary addAttributeTemplate(AttributeTemplate attributeTemplate) {
        if (attributeTemplate == null) {
            throw new IllegalArgumentException("Attribute definition must not be null");
        }
        int vendorId = attributeTemplate.getVendorId();
        int typeCode = attributeTemplate.getType();
        String attributeName = attributeTemplate.getName();
        if (this.attributesByName.containsKey(attributeName)) {
            AttributeTemplate existing = this.attributesByName.get(attributeName);
            if (existing.equals(attributeTemplate)) {
                logger.info("Ignoring duplicate attribute definition: {} [{},{}] {}, hasTag={}, encrypt={} ", (Object)existing.getName(), (Object)existing.getVendorId(), (Object)existing.getType(), (Object)existing.getDataType(), (Object)existing.isTagged(), (Object)existing.getCodecType());
                return this;
            }
            throw new IllegalArgumentException("Duplicate attribute definition name, existing attribute not equal to new attribute: " + attributeName);
        }
        this.attributesByName.put(attributeName, attributeTemplate);
        Map vendorAttributes = this.attributesByCode.computeIfAbsent(vendorId, k -> new HashMap());
        if (vendorAttributes.containsKey(typeCode)) {
            logger.warn("Duplicate type code [{},{}], overwriting {} with {}", (Object)vendorId, (Object)Integer.toUnsignedLong(typeCode), (Object)((AttributeTemplate)vendorAttributes.get(typeCode)).getName(), (Object)attributeTemplate.getName());
        }
        vendorAttributes.put(typeCode, attributeTemplate);
        return this;
    }
}

