/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.radius.common.dictionary;

import com.tplink.cdd.radius.common.attribute.type.AttributeType;
import com.tplink.cdd.radius.common.attribute.type.RadiusAttribute;
import com.tplink.cdd.radius.common.dictionary.CoreDictionary;
import io.netty.buffer.ByteBuf;

public interface Dictionary
extends CoreDictionary {
    default public RadiusAttribute createAttribute(int vendorId, int type, byte[] value) {
        return this.createAttribute(vendorId, type, (byte)0, value);
    }

    default public RadiusAttribute createAttribute(int vendorId, int type, byte tag, byte[] value) {
        return this.getAttributeTemplate(vendorId, type).map(at -> at.create(this, tag, value)).orElseGet(() -> AttributeType.OCTETS.create(this, vendorId, type, tag, value));
    }

    default public RadiusAttribute createAttribute(int vendorId, int type, ByteBuf data) {
        return this.getAttributeTemplate(vendorId, type).map(at -> at.parse(this, data)).orElseGet(() -> AttributeType.OCTETS.create(this, vendorId, data));
    }

    default public RadiusAttribute createAttribute(int vendorId, int type, String value) {
        return this.createAttribute(vendorId, type, (byte)0, value);
    }

    default public RadiusAttribute createAttribute(int vendorId, int type, byte tag, String value) {
        return this.getAttributeTemplate(vendorId, type).map(at -> at.create(this, tag, value)).orElseGet(() -> AttributeType.OCTETS.create(this, vendorId, type, tag, value));
    }

    default public RadiusAttribute createAttribute(String name, String value) {
        return this.getAttributeTemplate(name).orElseThrow(() -> new IllegalArgumentException("Unknown attribute type name: '" + name + "'")).create(this, (byte)0, value);
    }
}

