/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.radius.common.attribute.type;

import com.tplink.cdd.radius.common.RadiusPacketException;
import com.tplink.cdd.radius.common.attribute.AttributeHolder;
import com.tplink.cdd.radius.common.attribute.type.OctetsAttribute;
import com.tplink.cdd.radius.common.attribute.type.RadiusAttribute;
import com.tplink.cdd.radius.common.dictionary.Dictionary;
import com.tplink.cdd.radius.common.dictionary.Vendor;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class VendorSpecificAttribute
extends OctetsAttribute
implements AttributeHolder<VendorSpecificAttribute> {
    public static final byte VENDOR_SPECIFIC = 26;
    private final int childVendorId;
    private final List<RadiusAttribute> attributes;

    public VendorSpecificAttribute(Dictionary dictionary, int vendorId, ByteBuf data) {
        this(dictionary, VendorSpecificAttribute.validate(data).getInt(2), AttributeHolder.readAttributes(dictionary, data.getInt(2), data.slice(6, data.readableBytes() - 6)), data);
        if (vendorId != -1) {
            throw new IllegalArgumentException("Vendor-Specific attribute should be top level attribute, vendorId should be -1, actual: " + vendorId);
        }
    }

    private static ByteBuf validate(ByteBuf data) {
        int len = data.readableBytes();
        if (len < 7) {
            throw new IllegalArgumentException("Vendor-Specific attribute should be greater than 6 octets, actual: " + len);
        }
        return data;
    }

    public VendorSpecificAttribute(Dictionary dictionary, int childVendorId, List<RadiusAttribute> attributes) {
        this(dictionary, childVendorId, attributes, VendorSpecificAttribute.toByteBuf(childVendorId, attributes));
        boolean mismatchVendorId = attributes.stream().map(RadiusAttribute::getVendorId).anyMatch(id -> id != childVendorId);
        if (mismatchVendorId) {
            throw new IllegalArgumentException("Vendor-Specific attribute sub-attributes must have same vendorId as VSA childVendorId: " + childVendorId);
        }
    }

    private static ByteBuf toByteBuf(int childVendorId, List<RadiusAttribute> attributes) {
        ByteBuf attributesBytes = AttributeHolder.attributesToBytes(attributes);
        ByteBuf header = Unpooled.buffer((int)6, (int)6).writeByte(26).writeByte(attributesBytes.readableBytes() + 6).writeInt(childVendorId);
        return Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{header, attributesBytes});
    }

    private VendorSpecificAttribute(Dictionary dictionary, int childVendorId, List<RadiusAttribute> attributes, ByteBuf data) {
        super(dictionary, -1, data);
        this.childVendorId = childVendorId;
        this.attributes = Collections.unmodifiableList(new ArrayList<RadiusAttribute>(attributes));
        if (data.getByte(0) != 26) {
            throw new IllegalArgumentException("Vendor-Specific attribute attributeId should always be 26, actual: " + data.getByte(0));
        }
        VendorSpecificAttribute.validate(data);
    }

    @Override
    public int getChildVendorId() {
        return this.childVendorId;
    }

    @Override
    public List<RadiusAttribute> getAttributes() {
        return this.attributes;
    }

    @Override
    public VendorSpecificAttribute withAttributes(List<RadiusAttribute> attributes) {
        return new VendorSpecificAttribute(this.getDictionary(), this.getChildVendorId(), attributes);
    }

    @Override
    public List<RadiusAttribute> flatten() {
        return new ArrayList<RadiusAttribute>(this.getAttributes());
    }

    @Override
    public VendorSpecificAttribute encode(byte[] requestAuth, String secret) throws RadiusPacketException {
        return new VendorSpecificAttribute(this.getDictionary(), this.getChildVendorId(), this.encodeAttributes(requestAuth, secret));
    }

    @Override
    public VendorSpecificAttribute decode(byte[] requestAuth, String secret) throws RadiusPacketException {
        return new VendorSpecificAttribute(this.getDictionary(), this.getChildVendorId(), this.decodeAttributes(requestAuth, secret));
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Vendor-Specific: Vendor ID ").append(this.getChildVendorId());
        this.getDictionary().getVendor(this.getChildVendorId()).map(Vendor::getName).ifPresent(s -> sb.append(" (").append((String)s).append(")"));
        for (RadiusAttribute sa : this.getAttributes()) {
            sb.append("\n  ").append(sa.toString());
        }
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

