/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.radius.common.attribute.type;

import com.tplink.cdd.radius.common.RadiusPacketException;
import com.tplink.cdd.radius.common.attribute.AttributeTemplate;
import com.tplink.cdd.radius.common.dictionary.Dictionary;
import com.tplink.cdd.radius.common.dictionary.Vendor;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public interface RadiusAttribute {
    public int getVendorId();

    default public int getType() {
        switch (this.getTypeSize()) {
            case 2: {
                return this.getData().getShort(0);
            }
            case 4: {
                return this.getData().getInt(0);
            }
        }
        return Byte.toUnsignedInt(this.getData().getByte(0));
    }

    default public int getLength() {
        switch (this.getLengthSize()) {
            case 0: {
                return this.getData().readableBytes();
            }
            case 2: {
                return this.getData().getShort(this.getTypeSize());
            }
        }
        return Byte.toUnsignedInt(this.getData().getByte(this.getTypeSize()));
    }

    default public int getHeaderSize() {
        return this.getTypeSize() + this.getLengthSize();
    }

    public Optional<Byte> getTag();

    public byte[] getValue();

    public String getValueString();

    public Dictionary getDictionary();

    public ByteBuf getData();

    default public ByteBuf toByteBuf() {
        return Unpooled.unreleasableBuffer((ByteBuf)this.getData());
    }

    default public byte[] toByteArray() {
        return this.getData().copy().array();
    }

    default public int getTypeSize() {
        return this.getVendor().map(Vendor::getTypeSize).orElse(1);
    }

    default public int getLengthSize() {
        return this.getVendor().map(Vendor::getLengthSize).orElse(1);
    }

    default public int getTagSize() {
        return this.getDictionary().getAttributeTemplate(this.getVendorId(), this.getType()).map(AttributeTemplate::isTagged).orElse(false) != false ? 1 : 0;
    }

    default public Optional<Vendor> getVendor() {
        return this.getDictionary().getVendor(this.getVendorId());
    }

    default public boolean isTagged() {
        return this.getAttributeTemplate().map(AttributeTemplate::isTagged).orElse(false);
    }

    default public String getAttributeName() {
        return this.getAttributeTemplate().map(AttributeTemplate::getName).orElse(this.getVendorId() != -1 ? "Unknown-Sub-Attribute-" + this.getType() : "Unknown-Attribute-" + this.getType());
    }

    default public List<RadiusAttribute> flatten() {
        return Collections.singletonList(this);
    }

    default public Optional<AttributeTemplate> getAttributeTemplate() {
        return this.getDictionary().getAttributeTemplate(this.getVendorId(), this.getType());
    }

    default public RadiusAttribute encode(byte[] requestAuth, String secret) throws RadiusPacketException {
        return this;
    }

    default public RadiusAttribute decode(byte[] requestAuth, String secret) throws RadiusPacketException {
        return this;
    }

    default public boolean isEncoded() {
        return false;
    }
}

