/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.radius.common.attribute.type;

import com.tplink.cdd.radius.common.RadiusPacketException;
import com.tplink.cdd.radius.common.attribute.AttributeTemplate;
import com.tplink.cdd.radius.common.attribute.type.RadiusAttribute;
import com.tplink.cdd.radius.common.dictionary.Dictionary;
import com.tplink.cdd.radius.common.dictionary.Vendor;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import java.util.Optional;
import javax.xml.bind.DatatypeConverter;

public class OctetsAttribute
implements RadiusAttribute {
    private final Dictionary dictionary;
    private final ByteBuf data;
    private final int vendorId;

    public OctetsAttribute(Dictionary dictionary, int vendorId, ByteBuf data) {
        int lengthSize;
        this.dictionary = Objects.requireNonNull(dictionary, "Dictionary not set");
        this.vendorId = vendorId;
        this.data = Objects.requireNonNull(data, "Attribute data not set");
        int actualLength = data.readableBytes();
        if (actualLength > 255) {
            throw new IllegalArgumentException("Attribute too long, max 255 octets, actual: " + actualLength);
        }
        Optional<Vendor> vendor = dictionary.getVendor(vendorId);
        int typeSize = vendor.map(Vendor::getTypeSize).orElse(1);
        int length = this.extractLength(typeSize, lengthSize = vendor.map(Vendor::getLengthSize).orElse(1).intValue());
        if (length != actualLength) {
            throw new IllegalArgumentException("Attribute declared length is " + length + ", actual length: " + actualLength);
        }
    }

    private int extractLength(int typeSize, int lengthSize) {
        switch (lengthSize) {
            case 0: {
                return this.data.readableBytes();
            }
            case 2: {
                return this.data.getShort(typeSize);
            }
        }
        return Byte.toUnsignedInt(this.data.getByte(typeSize));
    }

    @Override
    public int getVendorId() {
        return this.vendorId;
    }

    @Override
    public Optional<Byte> getTag() {
        return this.isTagged() ? Optional.of(this.data.getByte(this.getHeaderSize())) : Optional.empty();
    }

    @Override
    public byte[] getValue() {
        int offset = this.getHeaderSize() + this.getTagSize();
        return this.data.slice(offset, this.data.readableBytes() - offset).copy().array();
    }

    @Override
    public String getValueString() {
        return "0x" + DatatypeConverter.printHexBinary((byte[])this.getValue());
    }

    @Override
    public Dictionary getDictionary() {
        return this.dictionary;
    }

    @Override
    public ByteBuf getData() {
        return this.data;
    }

    public String toString() {
        String tag = this.getTag().map(t -> ":" + t).orElse("");
        return this.getAttributeName() + tag + " = " + this.getValueString();
    }

    @Override
    public RadiusAttribute encode(byte[] requestAuth, String secret) throws RadiusPacketException {
        Optional<AttributeTemplate> template = this.getAttributeTemplate();
        return template.isPresent() ? template.get().encode(this, requestAuth, secret) : this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OctetsAttribute)) {
            return false;
        }
        OctetsAttribute that = (OctetsAttribute)o;
        return this.getVendorId() == that.getVendorId() && this.data.equals((Object)that.data);
    }

    public int hashCode() {
        return Objects.hash(this.data, this.getVendorId());
    }

    public static byte[] stringHexParser(String value) {
        return DatatypeConverter.parseHexBinary((String)value);
    }
}

