/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.radius.common.attribute.type;

import com.tplink.cdd.radius.common.attribute.AttributeTemplate;
import com.tplink.cdd.radius.common.attribute.type.OctetsAttribute;
import com.tplink.cdd.radius.common.dictionary.Dictionary;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.ByteBuffer;

public class LongAttribute
extends OctetsAttribute {
    public LongAttribute(Dictionary dictionary, int vendorId, ByteBuf data) {
        super(dictionary, vendorId, data);
        boolean b = !this.isTagged();
        int length = this.getValue().length;
        if (b && this.getValue().length != 4 && this.getValue().length != 8) {
            throw new IllegalArgumentException("Integer / Date should be 4 octets, actual: " + this.getValue().length);
        }
        if (this.isTagged() && this.getValue().length != 3) {
            throw new IllegalArgumentException("Integer / Date should be 3 octets if has_tag, actual: " + this.getValue().length);
        }
    }

    public long getValueLong() {
        byte[] value = this.getValue();
        return value.length == 4 ? (long)ByteBuffer.wrap(value).getInt() : ByteBuffer.wrap(value).getLong();
    }

    public int getValueInt() {
        byte[] value = this.getValue();
        return value.length == 4 ? ByteBuffer.wrap(value).getInt() : ByteBuffer.allocate(4).put((byte)0).put(value).getInt(0);
    }

    @Override
    public String getValueString() {
        long value = this.getValueLong();
        return this.getAttributeTemplate().map(at -> at.getEnumerationLong(value)).orElseGet(() -> Long.toUnsignedString(value));
    }

    public static byte[] stringParser(Dictionary dictionary, int vendorId, int type, String value) {
        long aLong = dictionary.getAttributeTemplate(vendorId, type).map(at -> at.getEnumerationLong(value)).orElseGet(() -> Long.parseUnsignedLong(value));
        ByteBuf byteBuf = Unpooled.buffer((int)8, (int)8).writeLong(aLong);
        return dictionary.getAttributeTemplate(vendorId, type).filter(AttributeTemplate::isTagged).map(x -> byteBuf.copy(1, 3)).orElse(byteBuf).array();
    }
}

