/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.radius.common.attribute.type;

import com.tplink.cdd.radius.common.attribute.type.OctetsAttribute;
import com.tplink.cdd.radius.common.dictionary.Dictionary;
import io.netty.buffer.ByteBuf;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.BitSet;

public class Ipv6PrefixAttribute
extends OctetsAttribute {
    public Ipv6PrefixAttribute(Dictionary dictionary, int vendorId, ByteBuf data) {
        super(dictionary, vendorId, data);
        byte[] value = this.getValue();
        Ipv6PrefixAttribute.validate(Ipv6PrefixAttribute.convertBytes(value), Byte.toUnsignedInt(value[1]));
    }

    private static byte[] validate(InetAddress address, int prefixLength) {
        if (prefixLength > 128 || prefixLength < 0) {
            throw new IllegalArgumentException("IPv6 Prefix Prefix-Length should be between 0 and 128, declared: " + prefixLength);
        }
        BitSet bitSet = BitSet.valueOf(address.getAddress());
        int bitSetLength = bitSet.length();
        if (bitSetLength > prefixLength) {
            throw new IllegalArgumentException("Prefix-Length is " + prefixLength + ", actual address has prefix length " + bitSetLength + ", bits outside of the Prefix-Length must be zero");
        }
        int prefixBytes = (int)Math.ceil((double)prefixLength / 8.0);
        byte[] addressBytes = bitSet.toByteArray();
        return ByteBuffer.allocate(2 + prefixBytes).put((byte)0).put((byte)prefixLength).put(addressBytes).array();
    }

    private static InetAddress convertString(String value) {
        if (value == null || value.isEmpty()) {
            throw new IllegalArgumentException("Invalid IPv6 prefix, empty: " + value);
        }
        try {
            String[] tokens = value.split("/");
            if (tokens.length != 2) {
                throw new IllegalArgumentException("Invalid IPv6 prefix expression, should be in format 'prefix/length': " + value);
            }
            return InetAddress.getByName(tokens[0]);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("Bad IPv6 prefix, invalid IPv6 address: " + value, e);
        }
    }

    private static InetAddress convertBytes(byte[] data) {
        if (data.length < 2 || data.length > 18) {
            throw new IllegalArgumentException("IPv6 Prefix body should be 2-18 octets (2-octet header + max 16 octet address), actual: " + data.length);
        }
        int availablePrefixBits = (data.length - 2) * 8;
        int prefixLength = Byte.toUnsignedInt(data[1]);
        if (availablePrefixBits < prefixLength) {
            throw new IllegalArgumentException("IPv6 Prefix Prefix-Length declared " + prefixLength + " bits, actual byte array only has space for " + availablePrefixBits + " bits");
        }
        return Ipv6PrefixAttribute.extractAddress(data);
    }

    private static InetAddress extractAddress(byte[] data) {
        try {
            byte[] array = ByteBuffer.allocate(16).put(data, 2, data.length - 2).array();
            return InetAddress.getByAddress(array);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("Bad IPv6 prefix, invalid IPv6 address: " + Arrays.toString(Arrays.copyOfRange(data, 2, data.length)), e);
        }
    }

    @Override
    public String getValueString() {
        byte[] data = this.getValue();
        return Ipv6PrefixAttribute.extractAddress(data).getHostAddress() + "/" + Byte.toUnsignedInt(data[1]);
    }

    public static byte[] stringParser(String value) {
        return Ipv6PrefixAttribute.validate(Ipv6PrefixAttribute.convertString(value), Integer.parseInt(value.split("/")[1]));
    }
}

