/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.radius.common.attribute.type;

import com.tplink.cdd.radius.common.attribute.type.OctetsAttribute;
import com.tplink.cdd.radius.common.dictionary.Dictionary;
import io.netty.buffer.ByteBuf;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;

public abstract class IpAttribute
extends OctetsAttribute {
    private IpAttribute(Dictionary dictionary, int vendorId, ByteBuf data) {
        super(dictionary, vendorId, data);
    }

    public static byte[] stringParser(String value) {
        if (value.isEmpty()) {
            throw new IllegalArgumentException("Address can't be empty");
        }
        try {
            return InetAddress.getByName(value).getAddress();
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("Bad address: " + value, e);
        }
    }

    private static InetAddress convert(byte[] data) {
        try {
            return InetAddress.getByAddress(data);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("Bad address", e);
        }
    }

    @Override
    public String getValueString() {
        return IpAttribute.convert(this.getValue()).getHostAddress();
    }

    public static class V6
    extends IpAttribute {
        public V6(Dictionary dictionary, int vendorId, ByteBuf data) {
            super(dictionary, vendorId, data);
            if (this.getValue().length != 16) {
                throw new IllegalArgumentException("IPv6 address should be 16 octets, actual: " + this.getValue().length);
            }
        }
    }

    public static class V4
    extends IpAttribute {
        public V4(Dictionary dictionary, int vendorId, ByteBuf data) {
            super(dictionary, vendorId, data);
            if (this.getValue().length != 4) {
                throw new IllegalArgumentException("IPv4 address should be 4 octets, actual: " + this.getValue().length);
            }
        }

        public int getValueInt() {
            return ByteBuffer.wrap(this.getValue()).getInt();
        }
    }
}

