/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.radius.common.attribute.type;

import com.tplink.cdd.radius.common.attribute.AttributeTemplate;
import com.tplink.cdd.radius.common.attribute.type.OctetsAttribute;
import com.tplink.cdd.radius.common.dictionary.Dictionary;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.ByteBuffer;

public class IntegerAttribute
extends OctetsAttribute {
    public IntegerAttribute(Dictionary dictionary, int vendorId, ByteBuf data) {
        super(dictionary, vendorId, data);
        if (!this.isTagged() && this.getValue().length != 4) {
            throw new IllegalArgumentException("Integer / Date should be 4 octets, actual: " + this.getValue().length);
        }
        if (this.isTagged() && this.getValue().length != 3) {
            throw new IllegalArgumentException("Integer / Date should be 3 octets if has_tag, actual: " + this.getValue().length);
        }
    }

    public long getValueLong() {
        return Integer.toUnsignedLong(this.getValueInt());
    }

    public int getValueInt() {
        byte[] value = this.getValue();
        return value.length == 4 ? ByteBuffer.wrap(value).getInt() : ByteBuffer.allocate(4).put((byte)0).put(value).getInt(0);
    }

    @Override
    public String getValueString() {
        int value = this.getValueInt();
        return this.getAttributeTemplate().map(at -> at.getEnumeration(value)).orElseGet(() -> Integer.toUnsignedString(value));
    }

    public static byte[] stringParser(Dictionary dictionary, int vendorId, int type, String value) {
        int integer = dictionary.getAttributeTemplate(vendorId, type).map(at -> at.getEnumeration(value)).orElseGet(() -> Integer.parseUnsignedInt(value));
        ByteBuf byteBuf = Unpooled.buffer((int)4, (int)4).writeInt(integer);
        return dictionary.getAttributeTemplate(vendorId, type).filter(AttributeTemplate::isTagged).map(x -> byteBuf.copy(1, 3)).orElse(byteBuf).array();
    }
}

