/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.radius.common.attribute.type;

import com.tplink.cdd.radius.common.RadiusPacketException;
import com.tplink.cdd.radius.common.attribute.AttributeTemplate;
import com.tplink.cdd.radius.common.attribute.codec.AttributeCodecType;
import com.tplink.cdd.radius.common.attribute.type.RadiusAttribute;
import com.tplink.cdd.radius.common.dictionary.Dictionary;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import java.util.Optional;

public class EncodedAttribute
implements RadiusAttribute {
    private final RadiusAttribute delegate;

    public EncodedAttribute(RadiusAttribute attribute) {
        this.delegate = Objects.requireNonNull(attribute);
        if (attribute instanceof EncodedAttribute) {
            throw new IllegalArgumentException("Cannot wrap EncodedDecorator twice");
        }
    }

    @Override
    public int getVendorId() {
        return this.delegate.getVendorId();
    }

    @Override
    public int getType() {
        return this.delegate.getType();
    }

    @Override
    public Optional<Byte> getTag() {
        return this.delegate.getTag();
    }

    @Override
    public ByteBuf getData() {
        return this.delegate.getData();
    }

    @Override
    public byte[] getValue() {
        return this.delegate.getValue();
    }

    @Override
    public String getValueString() {
        return this.delegate.getValueString();
    }

    @Override
    public RadiusAttribute decode(byte[] requestAuth, String secret) throws RadiusPacketException {
        Optional<AttributeTemplate> template = this.getAttributeTemplate();
        return template.isPresent() ? template.get().decode(this, requestAuth, secret) : this.delegate;
    }

    @Override
    public boolean isEncoded() {
        return true;
    }

    @Override
    public Dictionary getDictionary() {
        return this.delegate.getDictionary();
    }

    public String toString() {
        AttributeCodecType codecType = this.getAttributeTemplate().map(AttributeTemplate::getCodecType).orElse(AttributeCodecType.NO_ENCRYPT);
        return "[Encoded: " + codecType.name() + "] " + this.delegate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EncodedAttribute)) {
            return false;
        }
        EncodedAttribute that = (EncodedAttribute)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return Objects.hash(this.delegate);
    }
}

